/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.client;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Factory;
import com.filenet.api.property.PropertyFilter;
import com.filenet.api.security.User;
import com.filenet.api.util.UserContext;
import com.filenet.apiimpl.util.J2EEUtil;
import com.filenet.apiimpl.util.UTF8Helper;
import filenet.pe.ceutils.ConnectionPoint;
import filenet.pe.ceutils.ConnectionPoints;
import filenet.pe.ceutils.IdTypeFlags;
import filenet.pe.peorb.FileNet_PERPC.AppSpaceAccessLevel;
import filenet.pe.peorb.FileNet_PERPC.ApplicationSpaceInfo;
import filenet.pe.peorb.FileNet_PERPC.Attachment;
import filenet.pe.peorb.FileNet_PERPC.ClientConfigInfo;
import filenet.pe.peorb.FileNet_PERPC.ConfigHdrResult;
import filenet.pe.peorb.FileNet_PERPC.CreateResult;
import filenet.pe.peorb.FileNet_PERPC.DBConnection;
import filenet.pe.peorb.FileNet_PERPC.EnvironmentData;
import filenet.pe.peorb.FileNet_PERPC.FValue;
import filenet.pe.peorb.FileNet_PERPC.Field;
import filenet.pe.peorb.FileNet_PERPC.IndexDefinition;
import filenet.pe.peorb.FileNet_PERPC.LogDefinition;
import filenet.pe.peorb.FileNet_PERPC.PEConfig;
import filenet.pe.peorb.FileNet_PERPC.PERPCOperations;
import filenet.pe.peorb.FileNet_PERPC.ParticipantStruct;
import filenet.pe.peorb.FileNet_PERPC.Process;
import filenet.pe.peorb.FileNet_PERPC.QueryResult;
import filenet.pe.peorb.FileNet_PERPC.QueueDefinition;
import filenet.pe.peorb.FileNet_PERPC.QueueStatistics;
import filenet.pe.peorb.FileNet_PERPC.RPCHeader;
import filenet.pe.peorb.FileNet_PERPC.RPCHeaderHolder;
import filenet.pe.peorb.FileNet_PERPC.RedirectType;
import filenet.pe.peorb.FileNet_PERPC.Role;
import filenet.pe.peorb.FileNet_PERPC.RoleDefinitionInfo;
import filenet.pe.peorb.FileNet_PERPC.RosterDefinition;
import filenet.pe.peorb.FileNet_PERPC.RosterStatistics;
import filenet.pe.peorb.FileNet_PERPC.StackElement;
import filenet.pe.peorb.FileNet_PERPC.StepProcessorInfo;
import filenet.pe.peorb.FileNet_PERPC.StringAndFValue;
import filenet.pe.peorb.FileNet_PERPC.StringAndLong;
import filenet.pe.peorb.FileNet_PERPC.StringAndString;
import filenet.pe.peorb.FileNet_PERPC.SystemConfigInfo;
import filenet.pe.peorb.FileNet_PERPC.SystemWideConfig;
import filenet.pe.peorb.FileNet_PERPC.TableType;
import filenet.pe.peorb.FileNet_PERPC.TransferResult;
import filenet.pe.peorb.FileNet_PERPC.VWExceptionStruct;
import filenet.pe.peorb.FileNet_PERPC.WorkBasket;
import filenet.pe.peorb.FileNet_PERPC.WorkElement;
import filenet.pe.peorb.FileNet_PERPC.WorkElementUnion;
import filenet.pe.peorb.FileNet_PERPC.WorkObjectId;
import filenet.pe.peorb.FileNet_PERPC.WorkObjectIdOrVWExeption;
import filenet.pe.peorb.FileNet_PERPC.WorkfloSignature;
import filenet.pe.peorb.FileNet_PERPC.boolOrVWExeption;
import filenet.pe.peorb.FileNet_PERPC.longOrVWExeption;
import filenet.pe.peorb.client.CORBAExceptionHelper;
import filenet.pe.peorb.client.ClientInfoUtilities;
import filenet.pe.peorb.client.IPERPC;
import filenet.pe.peorb.client.IdTypeFlagsHolder;
import filenet.pe.peorb.client.JAASContext;
import filenet.pe.peorb.client.ORBFetchCEObject;
import filenet.pe.peorb.client.ORBFetchIsGroup;
import filenet.pe.peorb.client.ORBFetchMemberOf;
import filenet.pe.peorb.client.ORBFetchParticipants;
import filenet.pe.peorb.client.ORBFetchSecurityDomains;
import filenet.pe.peorb.client.ORBFetchUserList;
import filenet.pe.peorb.client.ORBIsMemberOfGroup;
import filenet.pe.peorb.client.ORBServiceHelper;
import filenet.pe.peorb.client.ORBUtility;
import filenet.pe.peorb.client.SyncVersion;
import filenet.pe.peorb.registry.ORBRouterInfo;
import filenet.vw.api.VWApplicationSpace;
import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWClassFactory;
import filenet.vw.api.VWCreateLiveWOResult;
import filenet.vw.api.VWDBExecuteConnection;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWMilestoneDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWParticipantList;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWQueueStats;
import filenet.vw.api.VWReturnStackElement;
import filenet.vw.api.VWRole;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRosterStats;
import filenet.vw.api.VWSecurityDomain;
import filenet.vw.api.VWServerException;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.base.CEObjectInfo;
import filenet.vw.base.RetryManager;
import filenet.vw.base.TTLObject;
import filenet.vw.base.VWParticipantCache;
import filenet.vw.base.VWTokenHelper;
import filenet.vw.base.VWUUID;
import filenet.vw.base.VWVersion;
import filenet.vw.base.VWXLIFFHandler;
import filenet.vw.base.logging.Logger;
import filenet.vw.base.logging.SessionTracker;
import filenet.vw.base.logging.VWTimerLog;
import filenet.vw.server.IPECommands;
import filenet.vw.server.InternalVWWorkBasket;
import filenet.vw.server.VWConfigInfo;
import filenet.vw.server.VWConfigResult;
import filenet.vw.server.VWEnvironmentData;
import filenet.vw.server.VWEnvironmentDataQueryResults;
import filenet.vw.server.VWField;
import filenet.vw.server.VWFieldUtility;
import filenet.vw.server.VWInjectInfo;
import filenet.vw.server.VWLogonCredentials;
import filenet.vw.server.VWLogonResult;
import filenet.vw.server.VWNoOnlineClassesException;
import filenet.vw.server.VWORBTimeoutException;
import filenet.vw.server.VWQueryResults;
import filenet.vw.server.VWSecurityQueryResults;
import filenet.vw.server.VWSystemConfigInfo;
import filenet.vw.server.VWSystemWideInfo;
import filenet.vw.server.VWWorkElementFields;
import filenet.vw.server.VWWorkObjectID;
import filenet.vw.server.VWWorkRecord;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.security.auth.Subject;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.NO_RESPONSE;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;

public class ORBSession
implements IPECommands,
Serializable {
    String m_className = "ORBSession";
    protected static Logger rpcLogger = Logger.getLogger("filenet.pe.peorb.rpc.only");
    protected static Logger logger = Logger.getLogger("filenet.pe.peorb.client");
    protected static Logger tokenLogger = Logger.getLogger("filenet.pe.peorb.client.token");
    protected static Logger inParamLogger = Logger.getLogger("filenet.pe.rpc.parameter.in");
    protected static Logger outParamLogger = Logger.getLogger("filenet.pe.rpc.parameter.out");
    protected static Logger timingLogger = Logger.getLogger("filenet.vw.shortcircuit");
    protected static Logger exceptionLogger = Logger.getLogger("filenet.pe.rpc.exception");
    protected static Logger callStackLogger = Logger.getLogger("filenet.pe.rpc.call.stack");
    protected static final String timerLoggerName = "filenet.pe.rpc.timer";
    private static boolean G_USE_NAMESEVICE = false;
    private static Hashtable PERPCMethodsTable;
    private static String shortCircuit;
    private static String noShortCircuit;
    protected static int RPC_CORBA_SLEEP;
    private static Object G_ORB_RETRY_COUNT_SYNC;
    private static long G_ORB_RETRY_COUNT;
    private static Object G_CONNECT_RETRY_COUNT_SYNC;
    private static long G_CONNECT_RETRY_COUNT;
    private static PropertyFilter USER_PF;
    private static final long serialVersionUID = 464L;
    private transient boolean clientConfigInfoSent = false;
    private String m_username = null;
    private String m_pw = null;
    private String m_realm = null;
    private boolean m_bNeedToLogonViaJAAS = false;
    private String m_cempUri = null;
    private VWConfigResult m_configResult = null;
    private ORBRouterInfo m_orbRouterInfo = null;
    private String m_origUrl = null;
    private String m_cpName = null;
    private transient ConnectionPoint m_connectionPoint = null;
    private transient JAASContext m_myJAASContext = null;
    private transient ORBServiceHelper m_orbSvc = null;
    private transient IPERPC m_peSvc = null;
    private transient RPCHeaderHolder m_rpcHeaderHolder = null;
    private transient ConfigHdrResult m_rpcConfigHdrResult = null;
    private transient boolean m_JAASContextChecked = false;
    private static VWTimerLog m_timer;
    private transient String m_id = null;
    private static final long RPC_TIMEOUT_DEFAULT = 300000L;
    private transient ORBFetchUserList[] ofulArray = new ORBFetchUserList[10];
    private transient int nextAvailOfulIndex = 0;
    private transient Locale clientLocale = null;
    private transient VWXLIFFHandler myXliff = null;
    private transient IdTypeFlagsHolder m_typeFlags = new IdTypeFlagsHolder();
    private transient String m_tokenUserName = null;
    private transient Subject m_ucSubject = null;
    private static WeakHashMap gNamesToIds;
    private static Logger nLogger;
    private static final String USTR_NONE = "(NONE)";
    private static final String USTR_ANYONE = "(ANYONE)";
    private static final String USTR_SERVICE = "ServiceProcess:System:System";
    private static final String USTR_INTERNAL_USER = "(INTERNAL USER)";
    private static final Long USER_NONE;
    private static final Long USER_ANYONE;
    private static final Long USER_UNDEFINED;
    private static final Long USER_SERVICE_PROCESS;
    private static final Long USER_USER_DEFAULTS;
    private static final Long USER_GROUP_DEFAULTS;
    private static final Long USER_DEVICE_DEFAULTS;
    private static final Long USER_SYSTEM_DEFAULTS;
    private static final Long USER_SERVPROCTERM;
    private transient VWParticipantCache TheParticipantCache = new VWParticipantCache();

    protected static final String GetPrivilegedSystemProperty(String propName) {
        final String fpropName = propName;
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(fpropName);
            }
        });
    }

    private static void GetPERPCMethods() {
        Method[] ms = PERPCOperations.class.getMethods();
        int nMethods = ms == null ? 0 : ms.length;
        PERPCMethodsTable = new Hashtable(nMethods);
        for (int i = 0; i < nMethods; ++i) {
            PERPCMethodsTable.put(ms[i].getName(), ms[i]);
        }
    }

    protected static Method getPERPCMethod(String rpcName) throws VWException {
        Method m = (Method)PERPCMethodsTable.get(rpcName);
        if (m == null) {
            throw new VWException("orb.session.invalidRPC", "Invalid RPC={0}.", rpcName);
        }
        return m;
    }

    public static String _get_FILE_DATE() {
        return "$Date:   16 June 2009 15:04:40  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.227  $";
    }

    private void startTiming(String location) {
        VWTimerLog thisThreadTimer = (VWTimerLog)m_timer.get();
        thisThreadTimer.setInitialLocation(location);
        if (thisThreadTimer.isLoggable()) {
            thisThreadTimer.setLocation("ORB\t" + this.m_id + ":" + this.m_username + "\t" + location);
        }
        thisThreadTimer.start();
    }

    private void stopTiming() {
        VWTimerLog thisThreadTimer = (VWTimerLog)m_timer.get();
        thisThreadTimer.stop();
        SyncVersion.updateStats(thisThreadTimer.getInitialLocation(), thisThreadTimer.elapsed());
    }

    private synchronized void getMyUUID() {
        if (this.m_id == null) {
            this.m_id = VWUUID.randomUUID().toString();
            SessionTracker.AddRef();
        }
    }

    private ClientConfigInfo getClientConfigInfo() {
        if (this.clientConfigInfoSent) {
            return null;
        }
        try {
            ClientConfigInfo c = new ClientConfigInfo(ClientInfoUtilities.G_HOST_ADDRESS, "pui460.004.038", ClientInfoUtilities.G_CE_BUILD_VERSION);
            this.clientConfigInfoSent = true;
            return c;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void checkTransientObjects(String rpc) throws VWException {
        String m_method = "checkTransientObjects:" + rpc;
        this.m_JAASContextChecked = false;
        if (this.m_orbSvc == null || this.m_peSvc == null) {
            this.establishORBSession(true);
        }
        if (this.TheParticipantCache == null) {
            this.TheParticipantCache = new VWParticipantCache();
        }
        this.getJAASContext(rpc);
    }

    private void establishORBSession(boolean pingIt) throws VWException {
        String m_method = "establishORBSession";
        try {
            this.getJAASContext("establishORBSession");
            this.m_className = "ORBSession:" + this.m_id + "," + this.m_connectionPoint;
            this.m_rpcHeaderHolder = null;
            if (this.m_orbRouterInfo == null) {
                this.m_orbRouterInfo = new ORBRouterInfo(this.m_connectionPoint.Name, this.m_connectionPoint.DNSName, this.m_connectionPoint.BrokerPort, this.m_connectionPoint.IsolatedRegionNumber);
            }
            if (this.m_orbSvc == null) {
                this.m_orbSvc = new ORBServiceHelper(this.m_orbRouterInfo, G_USE_NAMESEVICE);
            }
            this.getPERPCService();
            if (pingIt) {
                this.ping();
            }
        }
        catch (VWException vwEx) {
            throw vwEx;
        }
        catch (Throwable e) {
            logger.throwing(this.m_className, "establishORBSession", e);
            throw new VWException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JAASContext getJAASContextOnly(String rpc) throws VWException {
        JAASContext jAASContext;
        VWTimerLog timer = null;
        if (Logger.getLogger(timerLoggerName).isFinest()) {
            timer = new VWTimerLog("ORB\t" + this.m_id + ":" + this.m_username + "\tgetJAASContextOnly:" + rpc, timerLoggerName);
        }
        UserContext old = UserContext.get();
        try {
            if (this.m_ucSubject != null) {
                UserContext uc = new UserContext();
                UserContext.set((UserContext)uc);
                uc.pushSubject(this.m_ucSubject);
            }
            jAASContext = JAASContext.getJAASContext(this.m_bNeedToLogonViaJAAS, this.m_username, this.m_pw, this.m_cempUri, rpc);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block5: {
                Object var6_6 = null;
                UserContext.set((UserContext)old);
                if (timer == null) break block5;
                timer.stop();
            }
            throw throwable;
        }
        UserContext.set((UserContext)old);
        if (timer != null) {
            timer.stop();
        }
        return jAASContext;
    }

    private void getJAASContext(String rpc) throws VWException {
        if (!this.m_JAASContextChecked || this.m_myJAASContext == null) {
            JAASContext nowJAASContext;
            if (this.m_myJAASContext == null) {
                this.m_myJAASContext = this.getJAASContextOnly(rpc);
            } else if (!this.m_bNeedToLogonViaJAAS && !(nowJAASContext = this.getJAASContextOnly(rpc)).equals(this.m_myJAASContext)) {
                this.m_myJAASContext = nowJAASContext;
                this.m_connectionPoint = null;
            }
            this.m_JAASContextChecked = true;
        }
        if (this.m_connectionPoint == null) {
            this.getConnectionPoint(this.m_origUrl);
        }
    }

    private void destroyORB() {
        try {
            if (this.m_orbSvc != null) {
                this.m_orbSvc.destroyORB();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_orbSvc = null;
        this.m_peSvc = null;
    }

    private void getPERPCService() throws VWException {
        try {
            this.m_peSvc = this.m_orbSvc.getPERPC();
        }
        catch (Throwable t) {
            VWException vwe = new VWException("orb.session.FailedToConnectToVWORBBroker", "Failed to connect to vworbbroker on {0}.  Check server connection.", this.m_orbRouterInfo.toString());
            vwe.setCause(t);
            throw vwe;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getConnectionPoint(String url) throws VWException {
        String m_method = "getConnectionPoint:" + url;
        VWTimerLog timer = null;
        if (Logger.getLogger(timerLoggerName).isFinest()) {
            timer = new VWTimerLog("ORB\t" + this.m_id + ":" + this.m_username + "\tgetConnectionPoint", timerLoggerName);
        }
        try {
            try {
                block17: {
                    block16: {
                        Object paramUserName = this.m_username;
                        if (this.m_myJAASContext != null) {
                            paramUserName = this.m_myJAASContext;
                        }
                        this.m_connectionPoint = ConnectionPoints.GetConnectionPointFromBootstrapURI(url, paramUserName, this.m_pw);
                        if (this.m_connectionPoint == null) {
                            if (exceptionLogger.isFinest()) {
                                exceptionLogger.severe(this.m_className, m_method, "Failed to retrieve connection point for " + url);
                            }
                            VWException vwex = new VWException("orb.session.nullConnectionPoint", "Null Connection Point!");
                            logger.throwing(this.m_className, m_method, vwex);
                            throw vwex;
                        }
                        this.m_cpName = this.m_connectionPoint.Name;
                        try {
                            if (this.m_connectionPoint.IdentityToken == null && exceptionLogger.isFinest()) {
                                exceptionLogger.severe(this.m_className, m_method, "Connection Point has no identity Token?.");
                            }
                            if (this.m_typeFlags == null) {
                                this.m_typeFlags = new IdTypeFlagsHolder();
                            }
                            IdTypeFlags.extract(this.m_connectionPoint.IdentityToken, this.m_typeFlags);
                            if (this.m_typeFlags.name != null) {
                                try {
                                    this.m_tokenUserName = UTF8Helper.decodeString((byte[])this.m_typeFlags.name);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                            }
                            if (this.m_myJAASContext == null || this.m_typeFlags == null) break block16;
                            if (this.m_tokenUserName != null) break block17;
                        }
                        catch (Exception vwex) {
                            logger.throwing(this.m_className, m_method, vwex);
                            if (!(vwex instanceof VWException)) throw new VWException(vwex);
                            throw (VWException)vwex;
                        }
                    }
                    Object var7_9 = null;
                    if (timer == null) return;
                    timer.stop();
                    return;
                }
                this.m_myJAASContext.checkShortName(this.m_tokenUserName);
            }
            catch (MalformedURLException e) {
                throw new VWException("orb.session.invalidUrl", "{0} is invalid. ", this.m_origUrl);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (timer == null) throw throwable;
            timer.stop();
            throw throwable;
        }
        Object var7_10 = null;
        if (timer == null) return;
        timer.stop();
    }

    private String traceRPCHeader() {
        StringBuffer buf = new StringBuffer();
        RPCHeader hdr = this.m_rpcHeaderHolder == null ? null : this.m_rpcHeaderHolder.value;
        buf.append("\ntokenUserName=").append(this.m_tokenUserName);
        if (hdr == null) {
            buf.append("\nNULL RPCHeader");
        } else {
            buf.append("\nRPCHeader:").append("username=").append(hdr.userName).append(", rpcTimeStamp=").append(hdr.rpcTimeStamp).append(", adj=").append(hdr.adj).append(", lgTimeStamp=").append(hdr.lgTimeStamp).append(", wsTimeStamp=").append(hdr.wsTimeStamp).append(", regionId").append(hdr.regionId).append(", signedOK?").append(hdr.syncVersion == null ? "NO" : "YES");
        }
        return buf.toString();
    }

    public ORBSession(String url) throws VWException {
        this.getMyUUID();
        this.m_origUrl = url;
        if (ORBSession.StringEmpty(url)) {
            throw new VWException("orb.session.missingConnectionPoint", "Missing connection point information.");
        }
        this.m_cempUri = ConnectionPoints.GetCEURI(url);
        this.m_ucSubject = JAASContext.getCurrentUserContextSubject();
        this.establishORBSession(true);
    }

    public ORBSession() {
        this.getMyUUID();
        this.m_ucSubject = JAASContext.getCurrentUserContextSubject();
    }

    private boolean isAToken(String token) {
        String m_method = "isAToken";
        if (tokenLogger.isFinest()) {
            tokenLogger.finest(this.m_className, "isAToken", token);
        }
        boolean res = false;
        try {
            VWTokenHelper tk = VWTokenHelper.GetToken(token);
            this.m_username = tk.getName();
            this.m_pw = tk.getPw();
            if (tokenLogger.isFinest()) {
                tokenLogger.finest(this.m_className, "isAToken", this.m_username);
            }
            res = true;
        }
        catch (Exception e) {
            // empty catch block
        }
        return res;
    }

    public ORBSession(String url, String username, String pw, String realm) throws VWException {
        this.getMyUUID();
        if (ORBSession.StringEmpty(url)) {
            throw new VWException("orb.session.missingConnectionPoint", "Missing connection point information.");
        }
        this.m_cempUri = ConnectionPoints.GetCEURI(url);
        if (!this.isAToken(this.m_username)) {
            this.m_username = username;
            this.m_pw = pw;
        }
        this.m_origUrl = url;
        this.m_realm = realm;
        if (this.m_realm == null) {
            this.m_realm = "";
        }
        boolean bl = this.m_bNeedToLogonViaJAAS = this.m_username != null;
        if (!this.m_bNeedToLogonViaJAAS) {
            this.m_ucSubject = JAASContext.getCurrentUserContextSubject();
        }
        this.establishORBSession(true);
    }

    private static boolean StringEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private String getClientStr() {
        StringBuilder b = new StringBuilder(ClientInfoUtilities.G_CLIENT_INFO);
        b.append(":").append(this.m_id);
        if (this.clientLocale != null) {
            b.append(":").append(this.clientLocale);
        }
        return b.toString();
    }

    private void preRPCWork(String rpc) throws VWException {
        String m_method = "preRPCWork:" + rpc;
        boolean reset = false;
        String JAASusername = this.m_myJAASContext.getUserName();
        this.m_realm = this.m_myJAASContext.getDomain();
        if (this.m_username == null || !ORBSession.StringEmpty(JAASusername) && !JAASusername.toUpperCase().equals(this.m_username.toUpperCase())) {
            reset = true;
            this.m_username = JAASusername;
        }
        if (this.m_realm == null) {
            this.m_realm = "";
        }
        if (ORBSession.StringEmpty(this.m_username)) {
            throw new VWException("orb.session.missingUserName", "Missing user name.");
        }
        int rpcTimeStamp = (int)(new Date().getTime() / 1000L);
        byte[] peToken = null;
        String userName = this.m_username;
        if (this.m_typeFlags != null && this.m_typeFlags.token != null) {
            peToken = this.m_typeFlags.token;
            if (userName == null || userName.length() == 0 && this.m_tokenUserName != null) {
                try {
                    this.m_username = userName = this.m_tokenUserName;
                }
                catch (Exception e) {}
            } else if (!userName.equalsIgnoreCase(this.m_tokenUserName) && exceptionLogger.isFinest()) {
                exceptionLogger.severe(this.m_className, m_method, "token=" + this.m_tokenUserName + ", username=" + userName + " mismatched");
            }
        } else {
            if (exceptionLogger.isFinest()) {
                exceptionLogger.severe(this.m_className, m_method, "Sending empty TOKEN!");
            }
            peToken = new byte[]{};
        }
        if (this.m_rpcHeaderHolder == null) {
            PEConfig c = new PEConfig();
            ClientConfigInfo u = this.getClientConfigInfo();
            if (u != null) {
                c.u(u);
            } else {
                c.n(false);
            }
            String client = this.getClientStr();
            this.m_rpcHeaderHolder = new RPCHeaderHolder(new RPCHeader(client, userName, 0, this.m_realm, 0, 0, this.m_orbRouterInfo.region, c, rpcTimeStamp, null, peToken, 0));
        } else {
            this.m_rpcHeaderHolder.value.cVal.n(false);
            if (reset) {
                if (logger.isFinest()) {
                    logger.finest(this.m_className, m_method, "Resetting value to " + this.m_username + ", " + this.m_realm);
                }
                RPCHeader hdr = this.m_rpcHeaderHolder.value;
                hdr.realm = this.m_realm;
                hdr.userName = userName;
                hdr.userId = 0;
                hdr.lgTimeStamp = 0;
                hdr.rpcTimeStamp = rpcTimeStamp;
                hdr.syncVersion = null;
            }
            this.m_rpcHeaderHolder.value.typeFlags = peToken;
            this.m_rpcHeaderHolder.value.rpcTimeStamp = rpcTimeStamp;
        }
        this.m_rpcHeaderHolder.value.syncVersion = SyncVersion.generate(rpc, this.m_rpcHeaderHolder.value, this.m_typeFlags);
        if (this.m_rpcHeaderHolder.value.syncVersion == null) {
            this.m_rpcHeaderHolder.value.syncVersion = new byte[0];
            if (exceptionLogger.isFinest()) {
                exceptionLogger.severe(this.m_className, m_method, "Sending Empty Signature!");
            }
        }
    }

    private void postRPCWork(String rpc) {
        String m_method = "postRPCWork:" + rpc;
        try {
            switch (this.m_rpcHeaderHolder.value.cVal.discriminator()) {
                case 0: {
                    boolean reset = this.m_rpcHeaderHolder.value.cVal.n();
                    if (!reset) break;
                    this.m_configResult = null;
                    break;
                }
                case 1: {
                    this.m_rpcConfigHdrResult = this.m_rpcHeaderHolder.value.cVal.c();
                    if (this.m_configResult == null) {
                        this.m_configResult = new VWConfigResult();
                    }
                    this.m_configResult = ORBUtility.updateConfigResultFromConfigHdrResult(this.m_configResult, this.m_rpcConfigHdrResult);
                    this.m_configResult.setWsTimeStamp((long)this.m_rpcHeaderHolder.value.wsTimeStamp * 1000L);
                    this.m_rpcHeaderHolder.value.cVal.n(false);
                }
            }
        }
        catch (Exception e) {
            logger.throwing(this.m_className, m_method, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized Object executeRPC(String rpcName, Object[] params) throws VWException {
        Object res = null;
        String m_method = "executeRPC:" + rpcName;
        boolean firstTime = true;
        this.startTiming(rpcName);
        try {
            if (callStackLogger.isFinest()) {
                String sEnable = callStackLogger.getParameterValue(rpcName);
                boolean enable = false;
                if (sEnable != null) {
                    boolean bl = enable = !sEnable.equals("0");
                }
                if (enable) {
                    Exception e = new Exception("CALL STACK for " + rpcName);
                    callStackLogger.throwing(this.m_className, m_method, e);
                }
            }
            int nParams = params == null ? 0 : params.length;
            Object[] newParams = new Object[nParams + 1];
            for (int i = 0; i < nParams; ++i) {
                newParams[i + 1] = params[i];
            }
            RetryManager retry = new RetryManager(ORBServiceHelper.GetRPC_TIMEOUT(300000L));
            do {
                try {
                    this.checkTransientObjects(rpcName);
                    this.preRPCWork(rpcName);
                    newParams[0] = this.m_rpcHeaderHolder;
                    long startTime = 0L;
                    if (ORBServiceHelper.GUARD_SHARED_ORB) {
                        ORB oRB = this.m_orbSvc.getORB();
                        synchronized (oRB) {
                            if (rpcLogger.isFinest()) {
                                startTime = System.currentTimeMillis();
                                rpcLogger.finest(this.m_className, m_method, "[Serialize] Calling " + rpcName);
                            }
                            res = this.m_peSvc.invokeRPC(rpcName, newParams);
                            if (rpcLogger.isFinest()) {
                                long endTime = System.currentTimeMillis();
                                rpcLogger.finest(this.m_className, m_method, "[Serialize] Done Calling " + rpcName + " took " + (endTime - startTime) + "ms");
                            }
                        }
                    } else {
                        if (rpcLogger.isFinest()) {
                            startTime = System.currentTimeMillis();
                            rpcLogger.finest(this.m_className, m_method, "Calling " + rpcName);
                        }
                        res = this.m_peSvc.invokeRPC(rpcName, newParams);
                        if (rpcLogger.isFinest()) {
                            long endTime = System.currentTimeMillis();
                            rpcLogger.finest(this.m_className, m_method, "Done Calling " + rpcName + " took " + (endTime - startTime) + "ms");
                        }
                    }
                    this.postRPCWork(rpcName);
                    retry.stop();
                }
                catch (VWException vwex) {
                    throw vwex;
                }
                catch (Throwable ex) {
                    Object object;
                    Throwable cause = VWException.getRealCause(ex);
                    if (cause instanceof filenet.pe.peorb.FileNet_PERPC.VWException) {
                        filenet.pe.peorb.FileNet_PERPC.VWException serverEx = (filenet.pe.peorb.FileNet_PERPC.VWException)((Object)cause);
                        int errTuple = serverEx.errorTuple;
                        retry.setCauseObj(ORBUtility.mapServerException(serverEx));
                        switch (errTuple) {
                            case -714276828: {
                                throw new VWNoOnlineClassesException();
                            }
                            case -714276857: {
                                this.m_configResult = null;
                                this.m_rpcHeaderHolder.value.wsTimeStamp = 0;
                                throw ORBUtility.mapServerException(serverEx);
                            }
                            case -714276860: {
                                if (logger.isFinest()) {
                                    logger.finest(this.m_className, m_method, "Timeout. Try to recover the session.");
                                }
                                this.m_rpcHeaderHolder = null;
                                break;
                            }
                            case -714276846: {
                                if (logger.isFinest()) {
                                    logger.finest(this.m_className, m_method, "Operation Not Allowed at this time.  Try again");
                                }
                                retry.sleep(1000);
                                break;
                            }
                            case -720371712: {
                                if (logger.isFinest()) {
                                    logger.finest(this.m_className, m_method, "NULL return expected..");
                                }
                                object = null;
                                Object var18_26 = null;
                                this.stopTiming();
                                return object;
                            }
                            case -714276796: 
                            case -714276726: {
                                if (logger.isFinest()) {
                                    logger.finest(this.m_className, m_method, "TOKEN Timeout??" + this.traceRPCHeader());
                                }
                                if (!firstTime) {
                                    if (!exceptionLogger.isFinest()) throw ORBUtility.mapServerException(serverEx);
                                    exceptionLogger.severe(this.m_className, m_method, "Received PERPC Server Exception:" + errTuple + ", txt=" + serverEx.errorTxt);
                                    throw ORBUtility.mapServerException(serverEx);
                                }
                                this.m_rpcHeaderHolder = null;
                                this.m_myJAASContext = null;
                                this.m_connectionPoint = null;
                                this.m_typeFlags.token = null;
                                retry.expiredIn(10000L);
                                firstTime = false;
                                break;
                            }
                            default: {
                                if (!exceptionLogger.isFinest()) throw ORBUtility.mapServerException(serverEx);
                                exceptionLogger.severe(this.m_className, m_method, "Received PERPC Server Exception:" + errTuple + ", txt=" + serverEx.errorTxt);
                                throw ORBUtility.mapServerException(serverEx);
                            }
                        }
                        continue;
                    }
                    if (exceptionLogger.isFinest()) {
                        exceptionLogger.throwing(this.m_className, m_method, cause);
                    }
                    if (cause instanceof NO_RESPONSE || cause instanceof TRANSIENT || cause instanceof COMM_FAILURE) {
                        SystemException exx = (SystemException)cause;
                        CompletionStatus c = exx.completed;
                        if (c != null && c.equals(CompletionStatus.COMPLETED_MAYBE)) {
                            VWORBTimeoutException vwexx = new VWORBTimeoutException();
                            vwexx.setCause(cause);
                            throw vwexx;
                        }
                    }
                    if (cause instanceof SystemException) {
                        CORBAExceptionHelper helper = CORBAExceptionHelper.DescribeCORBAException((SystemException)cause);
                        VWException vwex = new VWException("orb.session.CORBAException", "{0}.  Check PE server.  Too busy.", helper.toString());
                        vwex.setCause(cause);
                        retry.setCauseObj(vwex);
                        if (!helper.getRetryable()) throw vwex;
                        if (exceptionLogger.isFinest()) {
                            object = G_ORB_RETRY_COUNT_SYNC;
                            synchronized (object) {
                                exceptionLogger.finest(this.m_className, m_method, "CORBA System Exception retry = " + ++G_ORB_RETRY_COUNT);
                            }
                        }
                        retry.sleep(RPC_CORBA_SLEEP);
                        this.ping();
                        continue;
                    }
                    if (!(cause instanceof ConnectException)) throw new VWException(cause);
                    VWException vwex = new VWException(cause);
                    retry.setCauseObj(vwex);
                    this.ping();
                    if (exceptionLogger.isFinest()) {
                        Object object2 = G_CONNECT_RETRY_COUNT_SYNC;
                        synchronized (object2) {
                            exceptionLogger.finest(this.m_className, m_method, "Connection Exception retry = " + ++G_CONNECT_RETRY_COUNT);
                        }
                    }
                    retry.sleep(RPC_CORBA_SLEEP);
                }
            } while (retry.again());
            if (!retry.getStatus() && retry.getCauseObj() != null) {
                throw (VWException)retry.getCauseObj();
            }
            if (exceptionLogger.isFinest() && res == null) {
                exceptionLogger.severe(this.m_className, m_method, "Unexpected NULL return value!!!");
            }
            Object object = res;
            Object var18_27 = null;
            this.stopTiming();
            return object;
        }
        catch (Throwable throwable) {
            Object var18_28 = null;
            this.stopTiming();
            throw throwable;
        }
    }

    public void logoff() throws VWException {
        String m_method = "logoff";
        if (this.m_peSvc != null) {
            this.m_peSvc.cleanup();
        }
        this.destroyORB();
        if (logger.isFinest()) {
            logger.finest(this.m_className, "logoff", "zapped myJAASContext");
        }
        this.m_myJAASContext = null;
        SessionTracker.Release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void ping() throws VWException {
        RetryManager retry = new RetryManager(ORBServiceHelper.GetRPC_TIMEOUT(300000L));
        do {
            Object var8_6;
            long startTime = System.currentTimeMillis();
            try {
                try {
                    if (this.m_peSvc == null) {
                        this.getPERPCService();
                    }
                    this.m_peSvc.invokeRPC("orb_rpc_ping", new Object[]{this.m_username + "," + ClientInfoUtilities.G_CLIENT_INFO});
                    retry.stop();
                }
                catch (Exception ex) {
                    if (exceptionLogger.isFinest()) {
                        exceptionLogger.throwing(this.m_className, "ping", ex);
                    }
                    if (!(ex instanceof SystemException)) {
                        throw new VWException(ex);
                    }
                    CORBAExceptionHelper helper = CORBAExceptionHelper.DescribeCORBAException((SystemException)ex);
                    VWException vwex = new VWException("orb.session.CORBAException", "{0}.  Check PE server.  Too busy.", helper.toString());
                    vwex.setCause(ex);
                    retry.setCauseObj(vwex);
                    if (!helper.getRetryable()) {
                        throw vwex;
                    }
                    retry.sleep(RPC_CORBA_SLEEP);
                    this.m_peSvc = null;
                    var8_6 = null;
                    SyncVersion.updateStats("orb_rpc_ping", System.currentTimeMillis() - startTime);
                    continue;
                }
                var8_6 = null;
            }
            catch (Throwable throwable) {
                var8_6 = null;
                SyncVersion.updateStats("orb_rpc_ping", System.currentTimeMillis() - startTime);
                throw throwable;
            }
            SyncVersion.updateStats("orb_rpc_ping", System.currentTimeMillis() - startTime);
        } while (retry.again());
        if (retry.getCauseObj() != null) {
            throw (VWException)retry.getCauseObj();
        }
    }

    public int getIsolatedRegion() {
        if (this.m_orbRouterInfo != null) {
            return this.m_orbRouterInfo.region;
        }
        return -1;
    }

    public String getUserName() throws VWException {
        String m_method = "getUserName";
        if (this.m_username == null || this.m_username.equals("")) {
            this.getJAASContext("getUserName");
            this.m_username = this.m_myJAASContext.getUserName();
        }
        if (logger.isFinest()) {
            logger.finest(this.m_className, "getUserName", this.m_username);
        }
        return this.m_username;
    }

    public String getServiceDestination() {
        try {
            this.checkTransientObjects("getServiceDestination");
            if (this.m_connectionPoint != null) {
                return this.m_connectionPoint.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "ERROR";
    }

    public int getSecurityType() {
        return 1;
    }

    public boolean isSecurityCaseSensitive() {
        return false;
    }

    public long getSecurityId() throws VWException {
        if (this.m_rpcHeaderHolder == null || this.m_rpcHeaderHolder.value == null) {
            this.executeRPC("orb_rpc_getCurrentVersion", null);
        }
        if (this.m_rpcHeaderHolder == null) {
            throw new VWNoOnlineClassesException();
        }
        return this.m_rpcHeaderHolder.value.userId;
    }

    public IPECommands getIPECommandsForDest(String dest) throws VWException {
        return this;
    }

    public String getToken() throws VWException {
        this.checkTransientObjects("getToken");
        return VWTokenHelper.GetToken(this.m_username, this.m_pw, this.m_cempUri, this.m_connectionPoint.Name);
    }

    public String getServerName() throws VWException {
        int inx;
        if (this.m_rpcConfigHdrResult == null) {
            this.executeRPC("orb_rpc_getCurrentVersion", null);
        }
        if (this.m_rpcConfigHdrResult == null) {
            throw new VWNoOnlineClassesException();
        }
        String servername = this.m_rpcConfigHdrResult.NCHServerName;
        if (servername != null && (inx = this.m_rpcConfigHdrResult.NCHServerName.indexOf("||")) != -1) {
            servername = this.m_rpcConfigHdrResult.NCHServerName.substring(0, inx);
        }
        return servername;
    }

    public VWGuid getObjectStoreId() throws VWException {
        String delim;
        int inx;
        if (this.m_rpcHeaderHolder == null || this.m_rpcHeaderHolder.value == null) {
            this.executeRPC("orb_rpc_getCurrentVersion", null);
        }
        if (this.m_rpcHeaderHolder == null) {
            throw new VWNoOnlineClassesException();
        }
        VWGuid objId = null;
        String serverNamePlusObjectServiceId = this.m_rpcConfigHdrResult.NCHServerName;
        if (serverNamePlusObjectServiceId != null && (inx = serverNamePlusObjectServiceId.indexOf(delim = "||")) != -1) {
            int inxend = serverNamePlusObjectServiceId.lastIndexOf(delim);
            String strObjId = serverNamePlusObjectServiceId.substring(inx + 2, inxend);
            objId = new VWGuid(strObjId);
        }
        return objId;
    }

    public String getDefaultDomain() throws VWException {
        return "";
    }

    public VWCreateLiveWOResult[] createLiveWorkObject(String[] fieldNames, Object[] fieldValues, String workflowIdentifier, int numberToCreate) throws VWException {
        FValue val;
        int fieldType;
        String m_method = "createLiveWorkObject:" + workflowIdentifier;
        inParamLogger.logObject(this.m_className, m_method, "FIELD NAMES", fieldNames);
        inParamLogger.logObject(this.m_className, m_method, "FIELD VALUES", fieldValues);
        Field[] fields = null;
        int i = 0;
        if (92626 == numberToCreate && workflowIdentifier.startsWith("~") && workflowIdentifier.substring(2, 4).equals("~~")) {
            numberToCreate = 1;
            int nFields = fieldNames.length + fieldValues.length;
            fields = new Field[nFields];
            for (i = 0; i < fieldNames.length; ++i) {
                fieldType = VWFieldType.getVWFieldType(fieldNames[i]);
                FValue val2 = ORBUtility.ObjectToFValue(fieldType, fieldNames[i]);
                fields[i] = new Field("Fa" + String.valueOf(i), val2, fieldType, false, false, 3, true, new boolean[0], "", "");
            }
            for (int j = 0; j < fieldValues.length; ++j) {
                int fieldType2 = VWFieldType.getVWFieldType(fieldValues[j]);
                val = ORBUtility.ObjectToFValue(fieldType2, fieldValues[j]);
                fields[i] = new Field("Fb" + String.valueOf(i), val, fieldType2, false, false, 3, true, new boolean[0], "", "");
                ++i;
            }
        } else if (fieldNames != null && fieldValues != null) {
            if (fieldNames.length != fieldValues.length) {
                throw new VWException("vw.api.SNumberofFieldNamesNotEqualNumberofFieldValues", "Number of field name must equal the number of field values.");
            }
            fields = new Field[fieldNames.length];
            for (i = 0; i < fieldNames.length; ++i) {
                if (fieldNames[i] == null) {
                    throw new VWException("vw.api.SFieldNameIsNull", "Field name is null: element={0}", i);
                }
                boolean isArray = false;
                if (fieldValues[i] != null) {
                    isArray = fieldValues[i].getClass().isArray();
                }
                fieldType = VWFieldType.getVWFieldType(fieldValues[i]);
                Object fieldValue = VWFieldUtility.convertFieldValue(fieldValues[i], fieldType, fieldNames[i], isArray);
                val = ORBUtility.ObjectToFValue(fieldType, fieldValue);
                fields[i] = new Field(fieldNames[i], val, fieldType, false, isArray, 3, true, new boolean[0], "", "");
            }
        }
        CreateResult[] res = null;
        VWCreateLiveWOResult[] vwRes = null;
        if (fields == null) {
            fields = new Field[]{};
        }
        try {
            res = (CreateResult[])this.executeRPC("orb_rpc_createLiveWorkObject", new Object[]{workflowIdentifier, fields, numberToCreate});
            if (res == null) {
                return null;
            }
        }
        catch (Exception e) {
            if (logger.isFinest()) {
                logger.throwing(this.m_className, m_method, e);
            }
            throw new VWException(e);
        }
        int resSize = res.length;
        vwRes = new VWCreateLiveWOResult[resSize];
        for (i = 0; i < resSize; ++i) {
            if (res[i].error == null || res[i].error.length() < 1) {
                vwRes[i] = VWClassFactory.createVWCreateLiveWOResult(res[i].rosterName, res[i].wobNum, null, 0L, 234L);
                continue;
            }
            if (i == 0) {
                if (res[i].error != null) {
                    if (res[i].error.indexOf("d5420003") != -1 || res[i].error.indexOf("2130660003") != -1) {
                        throw new VWServerException("vw.api.createLiveWorkObject.DuplicatWOB", "{0}", new Long(-717094909L), (Object)res[i].error);
                    }
                    if (res[i].error.indexOf("d5420006") != -1 || res[i].error.indexOf("2130660006") != -1) {
                        throw new VWServerException("vw.api.createLiveWorkObject.InvalidWOB", "{0}", new Long(-717094906L), (Object)res[i].error);
                    }
                    if (res[i].error.indexOf("d5420007") != -1 || res[i].error.indexOf("2130660007") != -1) {
                        throw new VWServerException("vw.api.createLiveWorkObject.ExpiredWOB", "{0}", new Long(-717094905L), (Object)res[i].error);
                    }
                }
                throw new VWException("vw.api.createLiveWorkObject", "Exception: {0}", res[i].error);
            }
            vwRes[i] = VWClassFactory.createVWCreateLiveWOResult(null, null, res[i].error, 0L, 234L);
        }
        return vwRes;
    }

    public Boolean checkVWVersion(String VWVersion2) throws VWException {
        return (Boolean)this.executeRPC("orb_rpc_checkVWVersion", new Object[]{VWVersion2});
    }

    public Boolean deleteInjectSession(String rosterName, String sessionName) throws VWException {
        return (Boolean)this.executeRPC("orb_rpc_deleteInjectSession", new Object[]{rosterName, sessionName});
    }

    public void deleteUserInfo(String userName) throws VWException {
        this.executeRPC("orb_rpc_deleteUserInfo", new Object[]{userName});
    }

    public String getCurrentVersion() throws VWException {
        return (String)this.executeRPC("orb_rpc_getCurrentVersion", null);
    }

    public String getFileFromServer(String fileName, int fileType) throws VWException {
        return (String)this.executeRPC("orb_rpc_getFileFromServer", new Object[]{fileName, fileType});
    }

    public Boolean getLimitApplicationFunctionalityFlag() throws VWException {
        return (Boolean)this.executeRPC("orb_rpc_getLimitApplicationFunctionalityFlag", null);
    }

    public Integer getQueueDepth(int viewId, boolean bBboundUserQueueDepth) throws VWException {
        return (Integer)this.executeRPC("orb_rpc_getQueueDepth", new Object[]{viewId, bBboundUserQueueDepth});
    }

    public Integer getRosterCount(int viewId) throws VWException {
        return (Integer)this.executeRPC("orb_rpc_getRosterCount", new Object[]{viewId});
    }

    public String getWorkClassXML(int workSpaceId, String workflowIdentifier, boolean bAuthorForm, boolean bConvert) throws VWException {
        return (String)this.executeRPC("orb_rpc_getWorkClassXML", new Object[]{workSpaceId, workflowIdentifier, bAuthorForm, bConvert});
    }

    public void initializeAllRegions() throws VWException {
        this.executeRPC("orb_rpc_initializeAllRegions", null);
    }

    public void initializeRegion(boolean bEmptyIt, int webApp) throws VWException {
        this.executeRPC("orb_rpc_initializeRegion", new Object[]{bEmptyIt, webApp});
    }

    public void logMessage(int viewId, int loggingOption, String msg) throws VWException {
        this.executeRPC("orb_rpc_logMessage", new Object[]{viewId, loggingOption, msg});
    }

    public void removeDatabase() throws VWException {
        this.executeRPC("orb_rpc_removeDatabase", null);
    }

    public VWConfigResult getConfigInfo(boolean refresh) throws VWException {
        if (this.m_configResult == null || refresh) {
            this.getLimitApplicationFunctionalityFlag();
            VWConfigInfo[] configinfoQ = null;
            VWConfigInfo[] configinfoR = null;
            if (this.m_configResult != null) {
                configinfoQ = this.m_configResult.getQueueConfigs();
                configinfoR = this.m_configResult.getRosterConfigs();
            }
            if (this.m_configResult == null || configinfoQ == null || configinfoQ.length == 0 || configinfoR == null || configinfoR.length == 0) {
                throw new VWNoOnlineClassesException();
            }
        }
        return this.m_configResult;
    }

    public VWLogonResult logon(VWLogonCredentials credentials) throws VWException {
        String m_method = "logon with VWLogonCredentials";
        if (logger.isFinest()) {
            logger.finest(this.m_className, "logon with VWLogonCredentials", noShortCircuit + " (Should we even be here?)");
        }
        throw new VWException("orb.session.notImplemented", "{0} NOT IMPLEMENTED", "logon with VWLogonCredentials");
    }

    public Hashtable getUserNames() throws VWException {
        String m_method = "getUserNames";
        if (logger.isFinest()) {
            logger.finest(this.m_className, "getUserNames", noShortCircuit + "(Deprecated - Shouldn't be using?)");
        }
        throw new VWException("orb.session.notImplementedEverInORB_RPCs", "ORBSession.{0}() NOT IMPLEMENTED, DEPRECATED, will not be implemented in the ORB rpc set", "getUserNames");
    }

    public Boolean recoverUser(String userName, String[] queueNames) throws VWException {
        String queueNamesAsString = Logger.asString(queueNames);
        String m_method = "recoverUser:" + userName + ":" + queueNamesAsString;
        if (userName == null) {
            if (exceptionLogger.isFinest()) {
                exceptionLogger.severe(this.m_className, m_method, "NULL userName!!!");
            }
            VWException vwex = new VWException("orb.session.recoverUser.invalidUserName", "API recoverUser provides invalid null userName!");
            throw vwex;
        }
        int nQueues = queueNames == null ? 0 : queueNames.length;
        boolean OK = nQueues > 0;
        for (int i = 0; i < nQueues && OK; ++i) {
            if (queueNames[i] != null) continue;
            OK = false;
        }
        if (!OK) {
            if (exceptionLogger.isFinest()) {
                exceptionLogger.severe(this.m_className, m_method, "NULL queueNames..");
            }
            VWException vwex = new VWException("orb.session.recoverUser.invalidQueueNames", "API recoverUser provides invalid null queue names.  Given queue names={0}", queueNamesAsString);
            throw vwex;
        }
        return (Boolean)this.executeRPC("orb_rpc_recoverUser", new Object[]{userName, queueNames});
    }

    public String[] getQueueNames(boolean includeSystemQueues, boolean ignoreSecurity) throws VWException {
        String[] res = (String[])this.executeRPC("orb_rpc_getQueueNames", new Object[]{includeSystemQueues, ignoreSecurity});
        return res;
    }

    public String[] getRosterNames(boolean ignoreSecurity) throws VWException {
        return (String[])this.executeRPC("orb_rpc_getRosterNames", new Object[]{ignoreSecurity});
    }

    public String[] getWorkClassNames(boolean ignoreSecurity, String baseWorkClassName) throws VWException {
        if (baseWorkClassName == null) {
            baseWorkClassName = "";
        }
        StringAndLong[] sandlArr = (StringAndLong[])this.executeRPC("orb_rpc_getWorkClassNames", new Object[]{ignoreSecurity, baseWorkClassName});
        String[] res = null;
        if (sandlArr != null) {
            int nItems = sandlArr.length;
            res = new String[nItems];
            for (int i = 0; i < nItems; ++i) {
                res[i] = sandlArr[i].s;
            }
        }
        return res;
    }

    public VWConfigInfo[] getWorkClassIdConfig() throws VWException {
        String baseWorkClassName = "";
        StringAndLong[] sandlArr = (StringAndLong[])this.executeRPC("orb_rpc_getWorkClassNames", new Object[]{true, baseWorkClassName});
        VWConfigInfo[] res = null;
        if (sandlArr != null) {
            InetAddress netaddr = null;
            int nItems = sandlArr.length;
            res = new VWConfigInfo[nItems];
            for (int i = 0; i < nItems; ++i) {
                res[i] = new VWConfigInfo(sandlArr[i].s, 0, sandlArr[i].l, 0, netaddr, false, 0, false);
            }
        }
        return res;
    }

    public VWAttributeInfo getAttributes(int nFlag) throws VWException {
        VWAttributeInfo resAttr = new VWAttributeInfo();
        StringAndFValue[] res = (StringAndFValue[])this.executeRPC("orb_rpc_getAttributes", new Object[]{nFlag});
        if (res != null) {
            int nItems = res.length;
            Hashtable<String, Object> attrHashT = new Hashtable<String, Object>();
            for (int i = 0; i < nItems; ++i) {
                attrHashT.put(res[i].s, ORBUtility.FieldValuetoVWObject(res[i].v, 0));
            }
            resAttr = VWClassFactory.createVWAttributeInfo(attrHashT, 234L);
        }
        return resAttr;
    }

    public VWProcess getProcess(int workSpaceId, int workClassId, String workflowNumber) throws VWException {
        Process res = null;
        VWProcess vwProc = null;
        if (workflowNumber == null) {
            workflowNumber = "";
        }
        if ((res = (Process)this.executeRPC("orb_rpc_getProcess", new Object[]{workSpaceId, workClassId, workflowNumber})) != null) {
            VWMilestoneDefinition[] theMileStoneDefinitions = null;
            if (res.MileStoneDefs != null) {
                int numMS = res.MileStoneDefs.length;
                theMileStoneDefinitions = new VWMilestoneDefinition[numMS];
                for (int i = 0; i < numMS; ++i) {
                    theMileStoneDefinitions[i] = ORBUtility.MilestoneToVWMilestone(res.MileStoneDefs[i]);
                }
            }
            vwProc = VWClassFactory.createVWProcess(res.RosterName, res.EventLogName, res.WorkClassName, res.WorkflowNumber, theMileStoneDefinitions, res.WorkSpaceId, res.WorkClassId, 234L);
        }
        return vwProc;
    }

    public String[] getLogNames() throws VWException {
        return (String[])this.executeRPC("orb_rpc_getLogNames", null);
    }

    public String[] getQueueOperations(String queueName) throws VWException {
        return (String[])this.executeRPC("orb_rpc_getQueueOperations", new Object[]{queueName});
    }

    public VWField[] getNewWorkObjectFields(String rosterName) throws VWException {
        String m_method = "getNewWorkObjectFields";
        if (logger.isFinest()) {
            logger.finest(this.m_className, "getNewWorkObjectFields", noShortCircuit + "(Deprecated - Shouldn't be using?)");
        }
        throw new VWException("orb.session.notImplementedEverInORB_RPCs", "ORBSession.{0}() NOT IMPLEMENTED, DEPRECATED, will not be implemented in the ORB rpc set", "getNewWorkObjectFields");
    }

    public VWQueryResults fetch(int viewId, int queryType, int resultType, int maxNumToReturn, String indexName, Object[] minValues, Object[] maxValues, int queryFlags, String preFilterSQL, Object[] substitutionValues, VWWorkRecord startRecord, double rpUniqueId, boolean userBoundQuery, String name, int workBasketId, String sortColumn, String[] filterNames) throws VWException {
        VWQueryResults results = null;
        if (indexName == null) {
            indexName = "";
        }
        if (preFilterSQL == null) {
            preFilterSQL = "";
        }
        if (name == null) {
            name = "";
        }
        FValue fvMinValues = ORBUtility.ObjectArrayToFValue(minValues);
        FValue fvMaxValues = ORBUtility.ObjectArrayToFValue(maxValues);
        FValue fvSubValues = ORBUtility.ObjectArrayToFValue(substitutionValues);
        WorkElement we = ORBUtility.VWWorkRecordToWorkElement(startRecord);
        QueryResult res = (QueryResult)this.executeRPC("orb_rpc_fetchQuery", new Object[]{viewId, queryType, resultType, maxNumToReturn, indexName, fvMinValues, fvMaxValues, queryFlags, preFilterSQL, fvSubValues, we, new Double(rpUniqueId), userBoundQuery, this.translateToAuthored(name), workBasketId, sortColumn == null ? "" : sortColumn, filterNames == null ? new String[]{} : filterNames});
        results = ORBUtility.getVWQueryResults(res, queryType);
        return results;
    }

    public Integer fetchCount(int viewId, int queryType, int resultType, String indexName, Object[] minValues, Object[] maxValues, int queryFlags, String preFilterSQL, Object[] substitutionValues, boolean userBoundQuery, String name, int workBasketId, String sortColumn, String[] filterNames) throws VWException {
        if (indexName == null) {
            indexName = "";
        }
        if (preFilterSQL == null) {
            preFilterSQL = "";
        }
        if (name == null) {
            name = "";
        }
        FValue fvMinValues = ORBUtility.ObjectArrayToFValue(minValues);
        FValue fvMaxValues = ORBUtility.ObjectArrayToFValue(maxValues);
        FValue fvSubValues = ORBUtility.ObjectArrayToFValue(substitutionValues);
        return (Integer)this.executeRPC("orb_rpc_fetchCount", new Object[]{viewId, queryType, resultType, indexName, fvMinValues, fvMaxValues, queryFlags, preFilterSQL, fvSubValues, userBoundQuery, name, workBasketId, sortColumn == null ? "" : sortColumn, filterNames == null ? new String[]{} : filterNames});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized VWSecurityQueryResults fetchUserList(int maxNumToReturn, int queryType, String startRecord, String searchPattern, String domain, int searchType, int sortType, long argFlag) throws VWException {
        String m_method = "fetchUserList";
        this.startTiming("fetchUserList");
        ORBFetchUserList oful = null;
        int myOfulIndex = 0;
        boolean firstTime = true;
        if (this.ofulArray == null) {
            this.ofulArray = new ORBFetchUserList[10];
        }
        if (logger.isFinest()) {
            logger.finest(this.m_className, "fetchUserList", shortCircuit);
        }
        try {
            try {
                block30: {
                    this.checkTransientObjects("fetchUserList");
                    try {
                        myOfulIndex = Integer.parseInt(startRecord);
                        oful = this.ofulArray[myOfulIndex];
                        this.ofulArray[myOfulIndex] = null;
                        firstTime = false;
                        if (logger.isFinest()) {
                            logger.finest(this.m_className, "fetchUserList", "Continuation call: startRecord was " + startRecord + ", oful=" + oful);
                        }
                        if (oful == null) {
                            throw new VWException("orb.session.fetchUserListStateLost", "fetchUserList state for continuation call has been lost");
                        }
                    }
                    catch (Exception e) {
                        oful = new ORBFetchUserList(this.m_cempUri, maxNumToReturn, queryType, startRecord, searchPattern, domain, searchType, sortType, argFlag);
                        firstTime = true;
                        if (!logger.isFinest()) break block30;
                        logger.finest(this.m_className, "fetchUserList", "New Call: startRecord was " + startRecord + ", oful=" + oful + ", query pattern=" + searchPattern);
                    }
                }
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "fetchUserList", "Searching for " + searchPattern + ", doing as " + this.m_myJAASContext.getUserName());
                }
                VWSecurityQueryResults myQueryResults = (VWSecurityQueryResults)J2EEUtil.getInstance().doAs(this.m_myJAASContext.getSubject(), (PrivilegedExceptionAction)oful);
                if (myQueryResults.queryIsOver) {
                    if (logger.isFinest()) {
                        logger.finest(this.m_className, "fetchUserList", "done with fetchUserList, so no state needs to be saved...");
                    }
                    if (firstTime) {
                        if (logger.isFinest()) {
                            logger.finest(this.m_className, "fetchUserList", " and no cleanup is needed because no state was prevously saved...");
                        }
                    } else {
                        if (logger.isFinest()) {
                            logger.finest(this.m_className, "fetchUserList", " and we're cleaning up oful[" + myOfulIndex + "], oful=" + oful);
                        }
                        this.ofulArray[myOfulIndex] = null;
                    }
                    oful = null;
                    startRecord = null;
                } else {
                    int reuseThisHole = -1;
                    ORBFetchUserList[] oRBFetchUserListArray = this.ofulArray;
                    // MONITORENTER : this.ofulArray
                    Calendar now = Calendar.getInstance();
                    for (int i = this.nextAvailOfulIndex - 1; i >= 0; --i) {
                        ORBFetchUserList o;
                        if (logger.isFinest()) {
                            logger.finest(this.m_className, "fetchUserList", "checking oful[" + i + "] (" + oful + ") for garbage collection");
                        }
                        if ((o = this.ofulArray[i]) == null) {
                            if (i == this.nextAvailOfulIndex - 1) {
                                --this.nextAvailOfulIndex;
                                if (!logger.isFinest()) continue;
                                logger.finest(this.m_className, "fetchUserList", "backing off nextAvailOfulIndex to " + this.nextAvailOfulIndex);
                                continue;
                            }
                            reuseThisHole = i;
                            continue;
                        }
                        Calendar c = o.getLastTouched();
                        long howLong = now.getTimeInMillis() - c.getTimeInMillis();
                        if (logger.isFinest()) {
                            logger.finest(this.m_className, "fetchUserList", "oful[" + i + "] (" + oful + ") is this old: " + howLong);
                        }
                        if (howLong <= 14400000L) continue;
                        this.ofulArray[i] = null;
                        if (logger.isFinest()) {
                            logger.finest(this.m_className, "fetchUserList", "tossing oful[" + i + "] (" + oful + ") as garbage");
                        }
                        if (i == this.nextAvailOfulIndex - 1) {
                            --this.nextAvailOfulIndex;
                            if (!logger.isFinest()) continue;
                            logger.finest(this.m_className, "fetchUserList", "backing off nextAvailOfulIndex to " + this.nextAvailOfulIndex);
                            continue;
                        }
                        reuseThisHole = i;
                    }
                    oful.setLastTouched();
                    myOfulIndex = reuseThisHole >= 0 ? reuseThisHole : this.nextAvailOfulIndex++;
                    myQueryResults.lastRecord = startRecord = String.valueOf(myOfulIndex);
                    if (myOfulIndex >= this.ofulArray.length) {
                        ORBFetchUserList[] temp = new ORBFetchUserList[this.ofulArray.length + 10];
                        for (int i = 0; i < this.ofulArray.length; ++i) {
                            temp[i] = this.ofulArray[i];
                        }
                        this.ofulArray = temp;
                    }
                    this.ofulArray[myOfulIndex] = oful;
                    if (logger.isFinest()) {
                        logger.finest(this.m_className, "fetchUserList", "fetchUserList state saved in oful[" + startRecord + "] oful=(" + oful + ")");
                    }
                    // MONITOREXIT : oRBFetchUserListArray
                }
                logger.exiting(this.m_className, "fetchUserList");
                VWSecurityQueryResults vWSecurityQueryResults = myQueryResults;
                Object var25_26 = null;
                this.stopTiming();
                return vWSecurityQueryResults;
            }
            catch (Exception e) {
                throw new VWException(e);
            }
        }
        catch (Throwable throwable) {
            Object var25_27 = null;
            this.stopTiming();
            throw throwable;
        }
    }

    public Boolean getLoggingState(int viewId, int loggingOption) throws VWException {
        String m_method = "getLoggingState";
        if (logger.isFinest()) {
            logger.finest(this.m_className, "getLoggingState", noShortCircuit + "(Deprecated - Shouldn't be using?)");
        }
        throw new VWException("orb.session.notImplementedEverInORB_RPCs", "ORBSession.{0}() NOT IMPLEMENTED, DEPRECATED, will not be implemented in the ORB rpc set", "getLoggingState");
    }

    public Object[] getLockStatus(int viewId, int queryType, VWWorkObjectID[] workObjectIds, boolean throwException, boolean userBoundQuery) throws VWException {
        if (workObjectIds == null || workObjectIds.length == 0) {
            return new Object[0];
        }
        WorkObjectId[] wobIds = ORBUtility.getWorkObjectIdsFromVWWorkObjectIds(workObjectIds);
        longOrVWExeption[] res = (longOrVWExeption[])this.executeRPC("orb_rpc_getLockStatus", new Object[]{wobIds, viewId, queryType, userBoundQuery});
        Object[] results = null;
        if (res != null) {
            int resSize = res.length;
            results = new Object[resSize];
            block4: for (int i = 0; i < resSize; ++i) {
                switch (res[i].discriminator().value()) {
                    case 1: {
                        VWExceptionStruct ORBVWEx = res[i].err();
                        if (ORBVWEx != null) {
                            filenet.pe.peorb.FileNet_PERPC.VWException vwEx = new filenet.pe.peorb.FileNet_PERPC.VWException(ORBVWEx.errorTuple, ORBVWEx.errorTxt, ORBVWEx.errorCause);
                            results[i] = ORBUtility.mapServerException(vwEx);
                            continue block4;
                        }
                        results[i] = new VWException("server.getLockStatus.exception2", "Null Exception");
                        continue block4;
                    }
                    case 0: {
                        results[i] = new Long(res[i].value());
                        continue block4;
                    }
                    default: {
                        throw new VWException("orb.session.getLockStatus.UnexpectedDescriminator", "Unexpected Descriminator value, {0}, in longOrVWExeption object", String.valueOf(res[i].discriminator().value()));
                    }
                }
            }
        }
        return results;
    }

    public Object[] unlockSave(int viewId, int queryType, VWWorkObjectID[] workObjectIds, int saveType, VWField[][] fieldValues, boolean bindAll, String userToBind, String exception, String exceptionDescription, boolean isExceptionMap, boolean unlockAll, boolean dispatchAll, boolean throwException, boolean userBoundQuery) throws VWException {
        if (workObjectIds == null) {
            throw new VWException("orb.session.unlockSaveNoWork", "No Work Objects to process");
        }
        if (exception == null) {
            exception = "";
        }
        if (exceptionDescription == null) {
            exceptionDescription = "";
        }
        if (userToBind == null) {
            userToBind = "";
        }
        WorkElement[] wElements = ORBUtility.WorkElementsFromFieldandIds(fieldValues, workObjectIds);
        WorkObjectIdOrVWExeption[] objres = (WorkObjectIdOrVWExeption[])this.executeRPC("orb_rpc_unlockSaveAndRedirect", new Object[]{viewId, queryType, saveType, wElements, exception, "", exceptionDescription, isExceptionMap, unlockAll, dispatchAll, userBoundQuery, "", "", RedirectType.UNLOCKSAVE_TYPE});
        if (objres == null) {
            return null;
        }
        Object[] res = ORBUtility.convertWorkObjectIdOrVWExeption(objres);
        return res;
    }

    public Boolean inject(String rosterName, VWField[][] fieldValues, String[] rosterNames, String sessionName, String transactionName) throws VWException {
        String m_method = "inject";
        if (logger.isFinest()) {
            logger.finest(this.m_className, "inject", noShortCircuit + "(Deprecated - Shouldn't be using?)");
        }
        throw new VWException("orb.session.notImplementedEverInORB_RPCs", "ORBSession.{0}() NOT IMPLEMENTED, DEPRECATED, will not be implemented in the ORB rpc set", "inject");
    }

    public VWInjectInfo getInjectSessionInfo(String rosterName, String sessionName, boolean nextName) throws VWException {
        String m_method = "getInjectSessionInfo";
        if (logger.isFinest()) {
            logger.finest(this.m_className, "getInjectSessionInfo", noShortCircuit + "(Deprecated - Shouldn't be using?)");
        }
        throw new VWException("orb.session.notImplementedEverInORB_RPCs", "ORBSession.{0}() NOT IMPLEMENTED, DEPRECATED, will not be implemented in the ORB rpc set", "getInjectSessionInfo");
    }

    public VWField[] getNewStepElement(String workClassName, boolean returnWobNum) throws VWException {
        VWField[] results = null;
        if (workClassName == null) {
            throw new VWException("orb.session.getNewStepElementWorkClassNULL", "WorkClass is null");
        }
        Field[] res = null;
        boolean isVWVersion = false;
        try {
            new VWVersion(workClassName);
            isVWVersion = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        res = (Field[])this.executeRPC("orb_rpc_getNewStepElement", new Object[]{workClassName, isVWVersion, returnWobNum});
        results = ORBUtility.FieldArraytoVWFieldArray(res);
        return results;
    }

    public Object[] saveNewStepElement(VWField[] fieldValues, String workClassName, int workspaceId, VWField[] initialfieldValues) throws VWException {
        Object[] results = null;
        StringAndLong res = null;
        if (workClassName == null) {
            throw new VWException("orb.session.SaveNewStepElementWorkClassNULL", "WorkClass name is null");
        }
        int nFields = fieldValues == null ? 0 : fieldValues.length;
        Vector<VWField> v = new Vector<VWField>();
        for (int i = 0; i < nFields; ++i) {
            if (fieldValues[i].getName().startsWith("*F_") || fieldValues[i].getType() == 0) continue;
            v.add(fieldValues[i]);
        }
        fieldValues = v.toArray(new VWField[0]);
        Field[] fields = ORBUtility.VWFieldArraytoFieldArray(fieldValues);
        nFields = initialfieldValues == null ? 0 : initialfieldValues.length;
        v = new Vector();
        for (int i = 0; i < nFields; ++i) {
            if (initialfieldValues[i].getName().startsWith("*F_") || initialfieldValues[i].getType() == 0) continue;
            initialfieldValues[i].setValue(initialfieldValues[i].getValue(), false);
            v.add(initialfieldValues[i]);
        }
        fieldValues = v.toArray(new VWField[0]);
        Field[] initialFields = ORBUtility.VWFieldArraytoFieldArray(fieldValues);
        res = (StringAndLong)this.executeRPC("orb_rpc_saveNewStepElement", new Object[]{fields, workClassName, workspaceId, initialFields});
        if (res != null) {
            results = new Object[]{res.s, res.l};
        }
        return results;
    }

    public VWField[] getNewStepFromVWVersion(String vwversion) throws VWException {
        VWField[] results = null;
        if (vwversion == null) {
            throw new VWException("orb.session.getNewStepFromVWVersionNullVersion", "VW Version string is null");
        }
        Field[] res = null;
        res = (Field[])this.executeRPC("orb_rpc_getNewStepElement", new Object[]{vwversion, true, false});
        results = ORBUtility.FieldArraytoVWFieldArray(res);
        return results;
    }

    public Object[] getWorkElementFields(int viewId, int queryType, VWWorkObjectID[] workObjectIds, int resultType, boolean lock, boolean overrideLock, boolean userBoundQuery, int queryFlags, int thecommand) throws VWException {
        if (workObjectIds == null || workObjectIds.length == 0) {
            return new Object[0];
        }
        WorkObjectId[] wobIds = ORBUtility.getWorkObjectIdsFromVWWorkObjectIds(workObjectIds);
        WorkElementUnion[] res = (WorkElementUnion[])this.executeRPC("orb_rpc_getWorkElementFields", new Object[]{viewId, queryType == 1 ? TableType.ROSTER_TYPE : (queryType == 3 ? TableType.LOGTYPE : TableType.QUEUE_TYPE), wobIds, resultType, "", lock, overrideLock, userBoundQuery, queryFlags, thecommand});
        Object[] results = null;
        if (res != null) {
            int arrSize = res.length;
            results = new Object[arrSize];
            block4: for (int i = 0; i < arrSize; ++i) {
                switch (res[i].discriminator().value()) {
                    case 1: {
                        filenet.pe.peorb.FileNet_PERPC.VWException vwEx = new filenet.pe.peorb.FileNet_PERPC.VWException(res[i].err().errorTuple, res[i].err().errorTxt, res[i].err().errorCause);
                        results[i] = ORBUtility.mapServerException(vwEx);
                        continue block4;
                    }
                    case 0: {
                        if (res[i].we().wobId != null && res[i].we().wobId.queueId != -999) {
                            VWField[] fields = ORBUtility.FieldArraytoVWFieldArray(res[i].we().fields);
                            VWWorkObjectID wobId = ORBUtility.getWorkObjectId(res[i].we().wobId);
                            results[i] = new VWWorkElementFields(fields, wobId);
                            continue block4;
                        }
                        results[i] = null;
                        continue block4;
                    }
                    default: {
                        throw new VWException("orb.session.getWorkElementFields.UnexpectedDescriminator", "Unexpected Descriminator value, {0}, in WorkElementUnion object", String.valueOf(res[i].discriminator()));
                    }
                }
            }
        }
        return results;
    }

    public Hashtable getIndexFields(String queueName) throws VWException {
        Hashtable<String, String[]> res = new Hashtable<String, String[]>();
        IndexDefinition[] resIDArr = (IndexDefinition[])this.executeRPC("orb_rpc_getIndexFields", new Object[]{queueName});
        if (resIDArr != null) {
            int nItems = resIDArr.length;
            for (int i = 0; i < nItems; ++i) {
                res.put(resIDArr[i].indexName, resIDArr[i].fieldNames);
            }
        }
        return res;
    }

    public String[] getExposedFields(String queueName) throws VWException {
        return (String[])this.executeRPC("orb_rpc_getExposedFields", new Object[]{queueName});
    }

    public Object[] terminateWorkObject(int viewId, int queryType, VWWorkObjectID[] workObjectIds, boolean throwException, boolean userBoundQuery) throws VWException {
        if (workObjectIds == null) {
            throw new VWException("orb.session.terminateWorkObjectNoWork", "No Work Objects to process");
        }
        WorkObjectId[] woIds = ORBUtility.getWorkObjectIdsFromVWWorkObjectIds(workObjectIds);
        boolOrVWExeption[] objres = (boolOrVWExeption[])this.executeRPC("orb_rpc_deleteWorkObject", new Object[]{woIds, viewId, queryType, Boolean.valueOf("true"), Boolean.valueOf("false"), throwException, userBoundQuery});
        Object[] results = null;
        if (objres != null) {
            int resSize = objres.length;
            results = new Object[resSize];
            block4: for (int i = 0; i < resSize; ++i) {
                switch (objres[i].discriminator().value()) {
                    case 1: {
                        VWExceptionStruct ORBVWEx = objres[i].err();
                        if (ORBVWEx != null) {
                            filenet.pe.peorb.FileNet_PERPC.VWException vwEx = new filenet.pe.peorb.FileNet_PERPC.VWException(ORBVWEx.errorTuple, ORBVWEx.errorTxt, ORBVWEx.errorCause);
                            results[i] = ORBUtility.mapServerException(vwEx);
                            continue block4;
                        }
                        results[i] = new VWException("server.terminateWob.exception2", "Null Exception");
                        continue block4;
                    }
                    case 0: {
                        results[i] = null;
                        continue block4;
                    }
                    default: {
                        throw new VWException("orb.session.terminateWorkObject.UnexpectedDescriminator", "Unexpected Descriminator value, {0}, in boolOrVWExeption object", String.valueOf(objres[i].discriminator().value()));
                    }
                }
            }
        }
        return results;
    }

    public Object[] deleteWorkObject(int viewId, int queryType, VWWorkObjectID[] workObjectIds, boolean overrideLock, boolean force, boolean throwException, boolean userBoundQuery) throws VWException {
        if (workObjectIds == null) {
            throw new VWException("orb.session.deleteWorkObjectNoWork", "No Work Objects to process");
        }
        WorkObjectId[] woIds = ORBUtility.getWorkObjectIdsFromVWWorkObjectIds(workObjectIds);
        boolOrVWExeption[] objres = (boolOrVWExeption[])this.executeRPC("orb_rpc_deleteWorkObject", new Object[]{woIds, viewId, queryType, Boolean.valueOf("false"), overrideLock, throwException, userBoundQuery});
        Object[] results = null;
        if (objres != null) {
            int resSize = objres.length;
            results = new Object[resSize];
            block4: for (int i = 0; i < resSize; ++i) {
                switch (objres[i].discriminator().value()) {
                    case 1: {
                        VWExceptionStruct ORBVWEx = objres[i].err();
                        if (ORBVWEx != null) {
                            filenet.pe.peorb.FileNet_PERPC.VWException vwEx = new filenet.pe.peorb.FileNet_PERPC.VWException(ORBVWEx.errorTuple, ORBVWEx.errorTxt, ORBVWEx.errorCause);
                            results[i] = ORBUtility.mapServerException(vwEx);
                            continue block4;
                        }
                        results[i] = new VWException("server.deleteWorkObject.exception2", "Null Exception");
                        continue block4;
                    }
                    case 0: {
                        results[i] = null;
                        continue block4;
                    }
                    default: {
                        throw new VWException("orb.session.deleteWorkObject.UnexpectedDescriminator", "Unexpected Descriminator value, {0}, in boolOrVWExeption object", String.valueOf(objres[i].discriminator().value()));
                    }
                }
            }
        }
        return results;
    }

    public void setSystemWideConfig(VWSystemWideInfo sysInfo) throws VWException {
        SystemWideConfig sysConfParam = new SystemWideConfig();
        int i = 0;
        VWDBExecuteConnection[] dbExecConnAry = sysInfo.getDBExecuteConnections();
        ArrayList<DBConnection> orbDBConList = new ArrayList<DBConnection>();
        if (dbExecConnAry != null) {
            for (int j = 0; j < dbExecConnAry.length; ++j) {
                if (dbExecConnAry[j] == null) continue;
                DBConnection orbDBCon = ORBUtility.VWDBExecuteConnectionToDBConnection(dbExecConnAry[j]);
                orbDBConList.add(orbDBCon);
            }
        }
        sysConfParam.dbConnectionArray = orbDBConList.toArray(new DBConnection[orbDBConList.size()]);
        if (sysInfo != null) {
            sysConfParam.sessionTimeOut = sysInfo.getSessionTimeOut();
            sysConfParam.statisticsConsolidationInterval = sysInfo.getStatisticsConsolidationInterval();
            sysConfParam.systemWideFlags = sysInfo.getSystemWideFlags();
            int numAttrs = sysInfo.getAttributes() != null ? sysInfo.getAttributes().size() : 0;
            sysConfParam.attributes = new StringAndFValue[numAttrs];
            if (numAttrs > 0) {
                Enumeration keys = sysInfo.getAttributes().keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    Object value = sysInfo.getAttributes().get(key);
                    sysConfParam.attributes[i] = new StringAndFValue();
                    sysConfParam.attributes[i].s = key;
                    sysConfParam.attributes[i].v = ORBUtility.ObjectToFValue(VWFieldType.getVWFieldType(value), value);
                    ++i;
                }
            }
        }
        this.executeRPC("orb_rpc_setSystemWideConfig", new Object[]{sysConfParam});
    }

    public VWSystemWideInfo getSystemWideConfig() throws VWException {
        SystemWideConfig res = (SystemWideConfig)this.executeRPC("orb_rpc_getSystemWideConfig", null);
        VWSystemWideInfo outRes = null;
        if (res != null) {
            outRes = new VWSystemWideInfo();
            outRes.setSessionTimeOut(res.sessionTimeOut);
            outRes.setStatisticsConsolidationInterval(res.statisticsConsolidationInterval);
            outRes.setSystemWideFlags(res.systemWideFlags);
            int numAttrs = res.attributes.length;
            if (numAttrs > 0) {
                Hashtable<String, Object> attrHashT = null;
                for (int i = 0; i < numAttrs; ++i) {
                    if (attrHashT == null) {
                        attrHashT = new Hashtable<String, Object>();
                    }
                    attrHashT.put(res.attributes[i].s, ORBUtility.FieldValuetoVWObject(res.attributes[i].v, 0));
                }
                if (attrHashT != null) {
                    outRes.setAttributes(attrHashT);
                }
            }
            int numDBCons = res.dbConnectionArray.length;
            ArrayList<VWDBExecuteConnection> dbExecConnArry = null;
            if (numDBCons > 0) {
                for (int i = 0; i < numDBCons; ++i) {
                    DBConnection dbCon = res.dbConnectionArray[i];
                    if (dbCon == null || dbCon.name.length() <= 0) continue;
                    if (dbExecConnArry == null) {
                        dbExecConnArry = new ArrayList<VWDBExecuteConnection>();
                    }
                    VWDBExecuteConnection dbExecConn = ORBUtility.DBConnectionToVWDBExecuteConnection(dbCon);
                    dbExecConnArry.add(dbExecConn);
                }
            }
            if (dbExecConnArry != null) {
                outRes.setDBExecuteConnections(dbExecConnArry.toArray(new VWDBExecuteConnection[dbExecConnArry.size()]));
            }
        }
        return outRes;
    }

    public Hashtable fetchServerConfiguration(String[] keyList) throws VWException {
        StringAndString[] resSSArr = (StringAndString[])this.executeRPC("orb_rpc_fetchServerConfiguration", new Object[]{keyList});
        int nItems = resSSArr == null ? 0 : resSSArr.length;
        Hashtable<String, String> res = new Hashtable<String, String>(nItems);
        for (int i = 0; i < nItems; ++i) {
            res.put(resSSArr[i].k, resSSArr[i].v);
        }
        return res;
    }

    public synchronized VWSecurityDomain[] fetchSecurityDomains() throws VWException {
        String m_method = "fetchSecurityDomains";
        if (logger.isFinest()) {
            logger.finest(this.m_className, "fetchSecurityDomains", shortCircuit);
        }
        this.startTiming("fetchSecurityDomains");
        try {
            this.checkTransientObjects("fetchSecurityDomains");
            ORBFetchSecurityDomains ofsd = new ORBFetchSecurityDomains(this.m_cempUri);
            if (logger.isFinest()) {
                logger.finest(this.m_className, "fetchSecurityDomains", "doing as " + this.m_myJAASContext.getUserName());
            }
            VWSecurityDomain[] securityDomains = (VWSecurityDomain[])J2EEUtil.getInstance().doAs(this.m_myJAASContext.getSubject(), (PrivilegedExceptionAction)ofsd);
            logger.exiting(this.m_className, "fetchSecurityDomains");
            VWSecurityDomain[] vWSecurityDomainArray = securityDomains;
            Object var6_6 = null;
            this.stopTiming();
            return vWSecurityDomainArray;
        }
        catch (Exception e) {
            try {
                throw new VWException(e);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.stopTiming();
                throw throwable;
            }
        }
    }

    public void saveUserInfo(VWEnvironmentData theUserInfo) throws VWException {
        if (theUserInfo == null) {
            return;
        }
        EnvironmentData env = ORBUtility.VWEnvironmentDataToEnvironmentData(theUserInfo);
        this.executeRPC("orb_rpc_saveUserInfo", new Object[]{env});
    }

    public VWEnvironmentData[] fetchUserInfo(String[] theUserNameList) throws VWException {
        VWEnvironmentData[] envArray = null;
        EnvironmentData[] res = null;
        if (theUserNameList == null) {
            throw new VWException("orb.session.fetchUserInfo.nullParam", "API fetchUserInfo has null parameter");
        }
        res = (EnvironmentData[])this.executeRPC("orb_rpc_fetchUserInfo", new Object[]{theUserNameList});
        if (res != null) {
            int nItems = res.length;
            envArray = new VWEnvironmentData[nItems];
            for (int i = 0; i < nItems; ++i) {
                envArray[i] = ORBUtility.EnvironmentDataToVWEnvironmentData(res[i]);
            }
        }
        return envArray;
    }

    public VWSystemConfigInfo getSystemConfigInfo(int productId) throws VWException {
        SystemConfigInfo res = null;
        VWSystemConfigInfo sysConfigInfo = null;
        res = (SystemConfigInfo)this.executeRPC("orb_rpc_getSystemConfigInfo", new Object[]{productId});
        if (res == null) {
            return null;
        }
        sysConfigInfo = ORBUtility.SystemConfigInfoToVWSystemConfigInfo(res);
        return sysConfigInfo;
    }

    public VWParticipant[] convertSecurityIdstoNames(Long[] ids) throws VWException {
        int i;
        int nItems;
        VWParticipant[] res = null;
        ParticipantStruct[] partArr = null;
        int[] idArray = null;
        if (ids != null) {
            nItems = ids.length;
            idArray = new int[nItems];
            for (i = 0; i < nItems; ++i) {
                idArray[i] = ids[i].intValue();
            }
        }
        if ((partArr = (ParticipantStruct[])this.executeRPC("orb_rpc_convertSecurityIdstoNames", new Object[]{idArray})) != null) {
            nItems = partArr.length;
            res = new VWParticipant[nItems];
            for (i = 0; i < nItems; ++i) {
                res[i] = ORBUtility.ParticipantToVWParticipant(partArr[i]);
            }
        }
        return res;
    }

    private String getKeyForNameCache(String name) {
        return name + "@" + this.m_connectionPoint.toString();
    }

    public Long[] convertSecurityNamestoIds(String[] names, boolean assignId) throws VWException {
        String m_method = "convertSecurityNamesToIds:" + Logger.asString(names);
        int nNames = names == null ? 0 : names.length;
        Long[] res = new Long[nNames];
        Vector<String> vNames = new Vector<String>();
        int[] vPos = new int[nNames];
        int k = 0;
        for (int i = 0; i < nNames; ++i) {
            String aUserName = names[i];
            if (USTR_NONE.equals(aUserName)) {
                res[i] = USER_NONE;
            }
            if (USTR_ANYONE.equals(aUserName)) {
                res[i] = USER_ANYONE;
            }
            if (USTR_SERVICE.equals(aUserName)) {
                res[i] = USER_SERVICE_PROCESS;
            }
            if (USTR_INTERNAL_USER.equals(aUserName)) {
                res[i] = USER_USER_DEFAULTS;
                continue;
            }
            Long l = null;
            TTLObject lTTL = (TTLObject)gNamesToIds.get(this.getKeyForNameCache(aUserName));
            if (lTTL != null) {
                l = (Long)lTTL.getObject();
            }
            if (l == null) {
                vNames.add(names[i]);
                vPos[k++] = i;
                res[i] = null;
                continue;
            }
            res[i] = l;
        }
        nLogger.finest(this.m_className, m_method, "Found:" + Logger.asString(res));
        int nNames2Check = vNames.size();
        if (nNames2Check > 0) {
            String[] realNames = vNames.toArray(new String[0]);
            int[] resIntArr = (int[])this.executeRPC("orb_rpc_convertSecurityNamestoIds", new Object[]{realNames, assignId});
            nLogger.finest(this.m_className, m_method, "From Server, " + Logger.asString(realNames) + "=" + Logger.asString(resIntArr));
            int nItems = resIntArr == null ? 0 : resIntArr.length;
            for (int j = 0; j < nItems; ++j) {
                int pos = vPos[j];
                Long theId = new Long(resIntArr[j]);
                if (pos < nNames) {
                    res[pos] = theId;
                }
                gNamesToIds.put(this.getKeyForNameCache(realNames[j]), new TTLObject(theId, "filenet.pe.id.cache.ttl"));
            }
        }
        nLogger.finest(this.m_className, m_method, Logger.asString(res));
        return res;
    }

    public VWTransferResult transfer(VWSystemConfigInfo systemConfig, VWWorkflowDefinition wflDefinition, String theWFDocKey, boolean theLinked, boolean theMakeNewWorkSpace, int productId) throws VWException {
        try {
            TransferResult res = null;
            if (wflDefinition != null) {
                if (theWFDocKey == null) {
                    theWFDocKey = "\"\"";
                }
                try {
                    String tmpStr = wflDefinition.AsXMLString() + "     ";
                    byte[] tmpBA = tmpStr.getBytes("UTF-8");
                    tmpBA[tmpBA.length - 1] = 0;
                    tmpBA[tmpBA.length - 2] = 0;
                    tmpBA[tmpBA.length - 3] = 0;
                    tmpBA[tmpBA.length - 4] = 0;
                    tmpBA[tmpBA.length - 5] = 0;
                    res = (TransferResult)this.executeRPC("orb_rpc_transferWorkflow", new Object[]{tmpBA, theWFDocKey, theLinked, theMakeNewWorkSpace, this.m_cpName});
                }
                catch (Exception e) {
                    VWException ex = new VWException("orb.session.UnexpectedTransferException", "Exception executing transfer WF RPC : {0}", e.getMessage());
                    ex.setCause(e);
                    throw ex;
                }
            } else {
                SystemConfigInfo OrbConfig = ORBUtility.makeORBConfigFromJavaConfig(systemConfig);
                res = (TransferResult)this.executeRPC("orb_rpc_transferConfig", new Object[]{OrbConfig, theMakeNewWorkSpace});
            }
            if (res == null) {
                return null;
            }
            VWTransferResult outRes = VWClassFactory.createVWTransferResult(234L);
            if (res.discriminator() == 0) {
                VWClassFactory.VWTransferResult_setErrors(outRes, res.errors(), 234L);
            } else if (res.discriminator() == 1) {
                VWClassFactory.VWTransferResult_setVersion(outRes, res.version(), 234L);
            } else {
                throw new VWException("orb.session.UnexpectedTransferResultWF", "Unexpected TransferResult, descriminator is {0}", String.valueOf(res.discriminator()));
            }
            return outRes;
        }
        catch (VWORBTimeoutException vwexx) {
            VWException newVWEx = new VWException("orb.session.TransferInProgress", "The system is processing the request.  However, it is taking longer than expected.   Please check back later for the result.");
            newVWEx.setCause(vwexx.getCause());
            throw newVWEx;
        }
    }

    public VWTransferResult transferWorkflowCollection(String wfCollectionStr, String theWFDocKey, boolean theLinked, boolean theMakeNewWorkSpace) throws VWException {
        TransferResult res = null;
        if (wfCollectionStr != null) {
            if (theWFDocKey == null) {
                theWFDocKey = "\"\"";
            }
            try {
                String tmpStr = wfCollectionStr + "     ";
                byte[] tmpBA = tmpStr.getBytes("UTF-8");
                tmpBA[tmpBA.length - 1] = 0;
                tmpBA[tmpBA.length - 2] = 0;
                tmpBA[tmpBA.length - 3] = 0;
                tmpBA[tmpBA.length - 4] = 0;
                tmpBA[tmpBA.length - 5] = 0;
                res = (TransferResult)this.executeRPC("orb_rpc_transferWorkflowCollection", new Object[]{tmpBA, theWFDocKey, theLinked, theMakeNewWorkSpace, this.m_cpName});
            }
            catch (Exception e) {
                VWException ex = new VWException("orb.session.UnexpectedTransferExceptionWFColl", "Exception executing transfer WF Collection RPC : {0}", e.getMessage());
                ex.setCause(e);
                throw ex;
            }
        }
        if (res == null) {
            return null;
        }
        VWTransferResult outRes = VWClassFactory.createVWTransferResult(234L);
        if (res.discriminator() == 0) {
            VWClassFactory.VWTransferResult_setErrors(outRes, res.errors(), 234L);
        } else if (res.discriminator() == 1) {
            VWClassFactory.VWTransferResult_setVersion(outRes, res.version(), 234L);
        } else {
            throw new VWException("orb.session.UnexpectedTransferResultWFColl", "Unexpected TransferResult, descriminator is {0}", String.valueOf(res.discriminator()));
        }
        return outRes;
    }

    public VWRosterDefinition getRosterDefinition(String rosterName) throws VWException {
        RosterDefinition res;
        if (rosterName == null) {
            rosterName = "";
        }
        if ((res = (RosterDefinition)this.executeRPC("orb_rpc_getRosterDefinition", new Object[]{rosterName})) == null) {
            return null;
        }
        return ORBUtility.makeVWRosterDefinition(res);
    }

    public VWQueueDefinition getQueueDefinition(String queueName) throws VWException {
        QueueDefinition res;
        if (queueName == null) {
            queueName = "";
        }
        if ((res = (QueueDefinition)this.executeRPC("orb_rpc_getQueueDefinition", new Object[]{queueName})) == null) {
            return null;
        }
        res.name = queueName;
        return ORBUtility.makeVWQueueDefinition(res);
    }

    public VWLogDefinition getLogDefinition(String logName) throws VWException {
        LogDefinition res;
        if (logName == null) {
            logName = "";
        }
        if ((res = (LogDefinition)this.executeRPC("orb_rpc_getLogDefinition", new Object[]{logName})) == null) {
            return null;
        }
        return ORBUtility.makeVWLogDefinition(res);
    }

    public void doReject(int viewId, int queryType, VWWorkObjectID workObjectId, int saveType) throws VWException {
        String m_method = "doReject";
        throw new VWException("orb.session.notImplemented", "{0} NOT IMPLEMENTED", "doReject");
    }

    public void doReassign(int viewId, int queryType, VWWorkObjectID workObjectId, int saveType, String domainName, String participantName, boolean delegateFlag, String queueName, VWField[] fieldValues, String exception, String exceptionDescription, boolean isExceptionMap, boolean throwException, boolean userBoundQuery, long argFlag) throws VWException {
        Object[] res;
        if (workObjectId == null) {
            throw new VWException("orb.session.doReassignNoWork", "No Work Objects to process");
        }
        if (exception == null) {
            exception = "";
        }
        if (exceptionDescription == null) {
            exceptionDescription = "";
        }
        if (domainName == null) {
            domainName = "";
        }
        if (participantName == null) {
            participantName = "";
        }
        if (queueName == null) {
            queueName = "";
        }
        RedirectType DirectType = null;
        DirectType = delegateFlag ? RedirectType.DELEGATE_TYPE : RedirectType.REASSIGN_TYPE;
        WorkElement[] wElements = new WorkElement[]{ORBUtility.WorkElementFromFieldandIds(fieldValues, workObjectId)};
        WorkObjectIdOrVWExeption[] objres = (WorkObjectIdOrVWExeption[])this.executeRPC("orb_rpc_unlockSaveAndRedirect", new Object[]{viewId, queryType, saveType, wElements, exception, queueName, exceptionDescription, isExceptionMap, false, false, userBoundQuery, domainName, participantName, DirectType});
        if (objres != null && (res = ORBUtility.convertWorkObjectIdOrVWExeption(objres)) != null && res[0] instanceof VWException) {
            throw (VWException)res[0];
        }
    }

    public void doReturn(int viewId, int queryType, VWWorkObjectID workObjectId, int saveType, VWField[] fieldValues, String exception, String exceptionDescription, boolean isExceptionMap, boolean throwException, boolean userBoundQuery) throws VWException {
        Object[] res;
        if (workObjectId == null) {
            throw new VWException("orb.session.doReturn", "No Work Objects to process");
        }
        if (exception == null) {
            exception = "";
        }
        if (exceptionDescription == null) {
            exceptionDescription = "";
        }
        WorkElement[] wElements = new WorkElement[]{ORBUtility.WorkElementFromFieldandIds(fieldValues, workObjectId)};
        WorkObjectIdOrVWExeption[] objres = (WorkObjectIdOrVWExeption[])this.executeRPC("orb_rpc_unlockSaveAndRedirect", new Object[]{viewId, queryType, saveType, wElements, exception, "", exceptionDescription, isExceptionMap, false, false, userBoundQuery, "", "", RedirectType.RETURN_TYPE});
        if (objres != null && (res = ORBUtility.convertWorkObjectIdOrVWExeption(objres)) != null && res[0] instanceof VWException) {
            throw (VWException)res[0];
        }
    }

    public VWQueueStats getQueueStatistics(int viewId, Date startTime, Date endTime, int timeUnits) throws VWException {
        QueueStatistics res = null;
        VWQueueStats qStats = null;
        if (startTime == null) {
            startTime = new Date();
        }
        if (endTime == null) {
            endTime = new Date();
        }
        if ((res = (QueueStatistics)this.executeRPC("orb_rpc_getQueueStatistics", new Object[]{viewId, (int)(startTime.getTime() / 1000L), (int)(endTime.getTime() / 1000L), timeUnits})) != null) {
            qStats = VWClassFactory.createVWQueueStats(res.className, (long)res.evaluationTime * 1000L, (long)res.startTime * 1000L, (long)res.endTime * 1000L, (long)res.userStartTime * 1000L, (long)res.userEndTime * 1000L, res.userTimeUnit, res.numOfSamples, res.numOfUnitsInPeriod, res.initialQueueCount, res.remainingQueuedCount, res.wOLockedCount, res.avgWOProcessingTime, res.avgThroughput, res.avgQueueDelay, res.wODequeuedCount, res.wOQueuedCount, res.abortedCount, res.serviceTime, res.abortedTime, res.wOProcessedCount, res.queuedRate, res.dequeuedRate, res.sumDurationWOInQueue, res.queueGrowthRate, res.avgQueueDepth, res.avgProcessedWOs, res.avgWOLocked, res.sumQueueDepth, res.sumNumberWOProcessed, res.sumWOLocked, res.currentQueueDepth, res.currentWOLocked, 234L);
        }
        return qStats;
    }

    public VWRosterStats getRosterStatistics(int viewId, Date startTime, Date endTime, int timeUnits) throws VWException {
        RosterStatistics res = null;
        VWRosterStats rStats = null;
        if (startTime == null) {
            startTime = new Date();
        }
        if (endTime == null) {
            endTime = new Date();
        }
        if ((res = (RosterStatistics)this.executeRPC("orb_rpc_getRosterStatistics", new Object[]{viewId, (int)(startTime.getTime() / 1000L), (int)(endTime.getTime() / 1000L), timeUnits})) != null) {
            rStats = VWClassFactory.createVWRosterStats(res.className, (long)res.evaluationTime * 1000L, (long)res.startTime * 1000L, (long)res.endTime * 1000L, (long)res.userStartTime * 1000L, (long)res.userEndTime * 1000L, res.userTimeUnit, res.numOfSamples, res.numOfUnitsInPeriod, res.initialWOsCount, res.initialParentsCount, res.initialChildrenCount, res.remainingTotalWOsCount, res.remainingParentsCount, res.remainingChildrenCount, res.createdTotalWOsCount, res.createdParentsCount, res.createdChildrenCount, res.terminatedTotalWOsCount, res.terminatedParentsCount, res.terminatedChildrenCount, res.creationTotalRate, res.creationParentRate, res.creationChildrenRate, res.terminationTotalRate, res.terminationParentRate, res.terminationChildrenRate, res.growTotalRate, res.growParentRate, res.growChildrenRate, res.sumWOLifeSpan, res.sumParentLifeSpan, res.sumChildrenLifeSpan, res.avgNumActiveWOs, res.avgNumActiveParents, res.avgNumActiveChildren, res.avgLifeSpanWOs, res.avgLifeSpanParents, res.avgLifeSpanChildren, res.sumActiveWOs, res.sumActiveParents, res.sumActiveChildren, res.currentWOsCount, res.currentParentsCount, res.currentChildrenCount, 234L);
        }
        return rStats;
    }

    public synchronized Boolean isMemberOfGroup(String groupName, String domainName, long rpcArgFlag) throws VWException {
        String m_method = "isMemberOfGroup";
        this.startTiming("isMemberOfGroup");
        if (logger.isFinest()) {
            logger.finest(this.m_className, "isMemberOfGroup", shortCircuit + "\nis " + this.m_username + " a member of " + groupName + "?");
        }
        this.checkTransientObjects("isMemberOfGroup");
        String groupToSearchFor = groupName;
        if (groupName.equals("SysConfigG")) {
            if (this.m_rpcConfigHdrResult == null) {
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "isMemberOfGroup", "checking SysConfigG mapping: don't have config info yet... make a cheap call to get new config info");
                }
                this.getConfigInfo(true);
            }
            if (this.m_rpcConfigHdrResult != null) {
                groupToSearchFor = this.m_rpcConfigHdrResult.mappedSysConfigG;
            }
            if (logger.isFinest()) {
                logger.finest(this.m_className, "isMemberOfGroup", "substituting " + groupToSearchFor + " for SysConfigG");
            }
        }
        if (groupName.equals("SysAdminG")) {
            if (this.m_rpcConfigHdrResult == null) {
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "isMemberOfGroup", "checking SysAdminG mapping: don't have config info yet... make a cheap call to get new config info");
                }
                this.getConfigInfo(true);
            }
            if (this.m_rpcConfigHdrResult != null) {
                groupToSearchFor = this.m_rpcConfigHdrResult.mappedSysAdminG;
            }
            if (logger.isFinest()) {
                logger.finest(this.m_className, "isMemberOfGroup", "substituting " + groupToSearchFor + " for SysAdminG");
            }
        }
        try {
            ORBIsMemberOfGroup oimog = new ORBIsMemberOfGroup(this.m_cempUri, groupToSearchFor, domainName, this.m_username, rpcArgFlag);
            oimog.setSubject(this.m_myJAASContext.getSubject());
            if (logger.isFinest()) {
                logger.finest(this.m_className, "isMemberOfGroup", "doing as " + this.m_myJAASContext.getUserName());
            }
            Boolean isMember = (Boolean)oimog.runEx();
            if (logger.isFinest()) {
                logger.finest(this.m_className, "isMemberOfGroup", this.m_username + " is " + (isMember != false ? "" : "NOT") + " a member of " + groupToSearchFor);
            }
            logger.exiting(this.m_className, "isMemberOfGroup");
            Boolean bl = isMember;
            Object var11_10 = null;
            this.stopTiming();
            return bl;
        }
        catch (Exception e) {
            try {
                throw new VWException(e);
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                this.stopTiming();
                throw throwable;
            }
        }
    }

    public synchronized Boolean[] fetchIsGroup(String[] names) throws VWException {
        String m_method = "fetchIsGroup";
        this.startTiming("fetchIsGroup");
        if (logger.isFinest()) {
            logger.finest(this.m_className, "fetchIsGroup", shortCircuit);
        }
        try {
            this.checkTransientObjects("fetchIsGroup");
            ORBFetchIsGroup ofig = new ORBFetchIsGroup(this.m_cempUri, names);
            if (logger.isFinest()) {
                logger.finest(this.m_className, "fetchIsGroup", "doing as " + this.m_myJAASContext.getUserName());
            }
            Boolean[] myResults = (Boolean[])J2EEUtil.getInstance().doAs(this.m_myJAASContext.getSubject(), (PrivilegedExceptionAction)ofig);
            logger.exiting(this.m_className, "fetchIsGroup");
            Boolean[] booleanArray = myResults;
            Object var7_7 = null;
            this.stopTiming();
            return booleanArray;
        }
        catch (Exception e) {
            try {
                throw new VWException(e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.stopTiming();
                throw throwable;
            }
        }
    }

    public synchronized String[] fetchMemberOf(String name) throws VWException {
        String m_method = "fetchMemberOf:" + name;
        this.startTiming("fetchMemberOf");
        if (logger.isFinest()) {
            logger.finest(this.m_className, m_method, shortCircuit);
        }
        try {
            this.checkTransientObjects(m_method);
            ORBFetchMemberOf ofmo = new ORBFetchMemberOf(this.m_cempUri, name);
            if (logger.isFinest()) {
                logger.finest(this.m_className, m_method, "doing as " + this.m_myJAASContext.getUserName());
            }
            String[] myResults = (String[])J2EEUtil.getInstance().doAs(this.m_myJAASContext.getSubject(), (PrivilegedExceptionAction)ofmo);
            logger.exiting(this.m_className, m_method);
            String[] stringArray = myResults;
            Object var7_7 = null;
            this.stopTiming();
            return stringArray;
        }
        catch (Exception e) {
            try {
                throw new VWException(e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.stopTiming();
                throw throwable;
            }
        }
    }

    public Boolean[] fetchAttachmentIsReferenced(VWAttachment[] theAttachments) throws VWException {
        int numAtts = 0;
        if (theAttachments == null || theAttachments.length == 0) {
            return new Boolean[0];
        }
        numAtts = theAttachments.length;
        Attachment[] orb_in_Attachments = new Attachment[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            String id = theAttachments[i].getId();
            String libraryName = theAttachments[i].getLibraryName();
            if (id == null) {
                id = "";
            }
            if (libraryName == null) {
                libraryName = "";
            }
            orb_in_Attachments[i] = new Attachment(id, theAttachments[i].getType(), libraryName, theAttachments[i].getLibraryType());
        }
        boolean[] res = (boolean[])this.executeRPC("orb_rpc_fetchAttachmentIsReferenced", new Object[]{orb_in_Attachments});
        if (res == null) {
            return null;
        }
        numAtts = res.length;
        Boolean[] results = new Boolean[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            results[i] = res[i];
        }
        return results;
    }

    public VWQueryResults fetchAttachmentIsReferencedBy(VWAttachment theAttachment, int theLimit, int workClassId, String wobNum) throws VWException {
        VWQueryResults results = null;
        if (theAttachment == null) {
            return null;
        }
        String id = theAttachment.getId();
        String libraryName = theAttachment.getLibraryName();
        if (id == null) {
            id = "";
        }
        if (libraryName == null) {
            libraryName = "";
        }
        Attachment orb_in_Attachment = new Attachment(id, theAttachment.getType(), libraryName, theAttachment.getLibraryType());
        QueryResult res = (QueryResult)this.executeRPC("orb_rpc_fetchAttachmentIsReferencedBy", new Object[]{orb_in_Attachment, theLimit, workClassId, wobNum});
        results = ORBUtility.getVWQueryResults(res, 1);
        return results;
    }

    public VWParticipantList fetchRoleParticipants(String roleName, String appSpaceName) throws VWException {
        if (appSpaceName == null) {
            appSpaceName = "";
        }
        String[] groupMembership = this.fetchMemberOf(this.m_username);
        ParticipantStruct[] rArr = (ParticipantStruct[])this.executeRPC("orb_rpc_fetchRoleParticipants", new Object[]{appSpaceName, roleName, groupMembership, Boolean.FALSE});
        VWParticipant[] res = ORBUtility.ParticipantArrayToVWParticipantArray(rArr);
        return VWClassFactory.createVWParticipantList(res);
    }

    public VWParticipantList fetchRoleParticipantsEx(String roleName, String appSpaceName, boolean isRunTimeCaller) throws VWException {
        if (appSpaceName == null) {
            appSpaceName = "";
        }
        String[] groupMembership = this.fetchMemberOf(this.m_username);
        ParticipantStruct[] rArr = (ParticipantStruct[])this.executeRPC("orb_rpc_fetchRoleParticipants", new Object[]{appSpaceName, roleName, groupMembership, isRunTimeCaller});
        VWParticipant[] res = ORBUtility.ParticipantArrayToVWParticipantArray(rArr);
        return VWClassFactory.createVWParticipantList(res);
    }

    public VWRole fetchMyRole(String roleName, String appSpaceName) throws VWException {
        if (roleName == null) {
            return null;
        }
        if (appSpaceName == null) {
            appSpaceName = "";
        }
        String[] groupMembership = this.fetchMemberOf(this.m_username);
        Role r = (Role)this.executeRPC("orb_rpc_fetchMyRole", new Object[]{roleName, appSpaceName, groupMembership});
        return ORBUtility.RoleToVWRole(r);
    }

    public VWRole[] fetchMyRoles(String shortName, String appSpaceName) throws VWException {
        if (shortName == null) {
            return null;
        }
        if (appSpaceName == null) {
            appSpaceName = "";
        }
        String[] groupMembership = this.fetchMemberOf(shortName);
        Role[] rArr = (Role[])this.executeRPC("orb_rpc_fetchMyRoles", new Object[]{appSpaceName, groupMembership});
        return ORBUtility.RoleArrayToVWRoleArray(rArr);
    }

    public InternalVWWorkBasket fetchMyWorkBasket(String roleName, String appSpaceName, int queueClassId, String workBasketName) throws VWException {
        if (roleName == null || appSpaceName == null || workBasketName == null) {
            return null;
        }
        String[] groupMembership = this.fetchMemberOf(this.m_username);
        WorkBasket wb = (WorkBasket)this.executeRPC("orb_rpc_fetchMyWorkBasket", new Object[]{appSpaceName, roleName, queueClassId, workBasketName, groupMembership});
        return ORBUtility.makeInternalVWWorkBasket(wb);
    }

    public InternalVWWorkBasket[] fetchMyWorkBaskets(String roleName, String appSpaceName) throws VWException {
        if (roleName == null || appSpaceName == null) {
            return null;
        }
        String[] groupMembership = this.fetchMemberOf(this.m_username);
        WorkBasket[] wbs = (WorkBasket[])this.executeRPC("orb_rpc_fetchMyWorkBaskets", new Object[]{appSpaceName, roleName, groupMembership});
        return ORBUtility.makeInternalVWWorkBasketArray(wbs);
    }

    public InternalVWWorkBasket[] fetchWorkBasketsForQueue(int queueClassId, String[] workBasketNames) throws VWException {
        if (workBasketNames == null) {
            workBasketNames = new String[]{};
        }
        WorkBasket[] wbs = (WorkBasket[])this.executeRPC("orb_rpc_fetchWorkBasketsFromQueue", new Object[]{queueClassId, workBasketNames});
        return ORBUtility.makeInternalVWWorkBasketArray(wbs);
    }

    public int fetchPrivileges() throws VWException {
        Integer flags = (Integer)this.executeRPC("orb_rpc_fetchPrivileges", null);
        if (flags != null) {
            return flags;
        }
        return 0;
    }

    public void removeLinkFlag(String theDocument) throws VWException {
        this.executeRPC("orb_rpc_removeDatabase", new Object[]{theDocument});
    }

    public VWStepProcessorInfo[] getStepProcessorList(int processorType, int productId) throws VWException {
        String m_method = "getStepProcessorList";
        StepProcessorInfo[] res = null;
        VWStepProcessorInfo[] stepInfoList = null;
        res = (StepProcessorInfo[])this.executeRPC("orb_rpc_getStepProcessorList", new Object[]{processorType, productId});
        if (res == null) {
            return null;
        }
        int stLength = res.length;
        stepInfoList = new VWStepProcessorInfo[stLength];
        for (int i = 0; i < stLength; ++i) {
            stepInfoList[i] = ORBUtility.StepProcessortoVWStepProcessor(res[i]);
        }
        return stepInfoList;
    }

    public VWStepProcessorInfo getLaunchStepProcessor(String workflowIdentifier, int productId) throws VWException {
        String m_method = "getLaunchStepProcessor";
        if (workflowIdentifier == null) {
            return null;
        }
        StepProcessorInfo res = null;
        res = (StepProcessorInfo)this.executeRPC("orb_rpc_getLaunchStepProcessor", new Object[]{workflowIdentifier, productId});
        if (res == null) {
            return null;
        }
        VWStepProcessorInfo result = ORBUtility.StepProcessortoVWStepProcessor(res);
        return result;
    }

    public VWStepProcessorInfo getStepProcessorByName(String processName, int productId) throws VWException {
        if (processName == null) {
            return null;
        }
        String m_method = "getStepProcessorByName";
        StepProcessorInfo res = (StepProcessorInfo)this.executeRPC("orb_rpc_getStepProcessorByName", new Object[]{processName, productId});
        if (res == null) {
            return null;
        }
        VWStepProcessorInfo result = ORBUtility.StepProcessortoVWStepProcessor(res);
        return result;
    }

    public VWStepProcessorInfo getStepProcessorById(int processorId, int productId) throws VWException {
        String m_method = "getStepProcessorById";
        StepProcessorInfo res = (StepProcessorInfo)this.executeRPC("orb_rpc_getStepProcessorById", new Object[]{processorId, productId});
        if (res == null) {
            return null;
        }
        VWStepProcessorInfo result = ORBUtility.StepProcessortoVWStepProcessor(res);
        return result;
    }

    public VWWorkflowSignature getWorkflowSignature(String workflowIdentifier) throws VWException {
        if (workflowIdentifier == null) {
            return null;
        }
        WorkfloSignature wfSig = (WorkfloSignature)this.executeRPC("orb_rpc_getWorkflowSignature", new Object[]{workflowIdentifier});
        return ORBUtility.WorkflowSignaturetoVWWorkflowSignature(wfSig);
    }

    public VWWorkflowSignature[] getMultipleWorkflowSignatures(int flags) throws VWException {
        WorkfloSignature[] wfSigs = (WorkfloSignature[])this.executeRPC("orb_rpc_getMultipleWorkflowSignatures", new Object[]{flags});
        return ORBUtility.WorkflowSignatureArraytoVWWorkflowSignatureArray(wfSigs);
    }

    public VWReturnStackElement[] getReturnStackElements(int viewId, int queryType, VWWorkObjectID workObjectId, boolean userBoundQuery) throws VWException {
        if (workObjectId == null) {
            return new VWReturnStackElement[0];
        }
        StackElement[] res = null;
        VWReturnStackElement[] result = null;
        res = (StackElement[])this.executeRPC("orb_rpc_RosterOrQueueGetReturnStackElements", new Object[]{queryType == 1 ? TableType.ROSTER_TYPE : TableType.QUEUE_TYPE, viewId, new WorkObjectId(workObjectId.getUniqueID(), workObjectId.getWorkObjectNumber(), workObjectId.getQueueId()), userBoundQuery});
        if (res == null) {
            return null;
        }
        int retLength = res.length;
        result = new VWReturnStackElement[retLength];
        for (int i = 0; i < retLength; ++i) {
            result[i] = VWClassFactory.createVWReturnStackElement(res[i].MapName, res[i].MapId, res[i].StepName, res[i].StepId, "0x" + Integer.toHexString(res[i].errorNum), res[i].errorMsg, 234L);
        }
        return result;
    }

    public VWEnvironmentDataQueryResults fetchUserEnvironmentRecords(int maxBufferSize, VWEnvironmentData startRecord, boolean ThrowException) throws VWException {
        VWEnvironmentData[] envArray = null;
        VWEnvironmentDataQueryResults envRes = null;
        BooleanHolder theQueryIsOver = new BooleanHolder(false);
        EnvironmentData[] res = (EnvironmentData[])this.executeRPC("orb_rpc_fetchUserEnvironmentRecords", new Object[]{maxBufferSize, startRecord == null ? "" : startRecord.getUserName(), theQueryIsOver, ThrowException});
        if (res != null) {
            int nItems = res.length;
            envArray = new VWEnvironmentData[nItems];
            for (int i = 0; i < nItems; ++i) {
                envArray[i] = ORBUtility.EnvironmentDataToVWEnvironmentData(res[i]);
            }
        }
        envRes = new VWEnvironmentDataQueryResults(envArray, theQueryIsOver.value);
        return envRes;
    }

    public synchronized VWParticipant[] fetchParticipants(String domainName, String[] theUserNameList, long rpcArgFlag) throws VWException {
        int nItems;
        block11: {
            String m_method = "fetchParticipants";
            this.startTiming("fetchParticipants");
            if (logger.isFinest()) {
                logger.finest(this.m_className, "fetchParticipants", shortCircuit);
            }
            this.checkTransientObjects("fetchParticipants");
            int n = nItems = theUserNameList == null ? 0 : theUserNameList.length;
            if (nItems != 0) break block11;
            VWParticipant[] vWParticipantArray = null;
            Object var17_9 = null;
            this.stopTiming();
            return vWParticipantArray;
        }
        try {
            VWParticipant[] results = new VWParticipant[nItems];
            Vector listToFetch = new Vector(nItems);
            this.TheParticipantCache.checkNames(domainName, theUserNameList, results, listToFetch);
            if (listToFetch.size() > 0) {
                VWParticipant[] myResults;
                int nNewItems;
                String[] realList = listToFetch.toArray(new String[0]);
                ORBFetchParticipants ofp = new ORBFetchParticipants(this.m_cempUri, domainName, realList, rpcArgFlag);
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "fetchParticipants", "doing as " + this.m_myJAASContext.getUserName());
                }
                int n = nNewItems = (myResults = (VWParticipant[])J2EEUtil.getInstance().doAs(this.m_myJAASContext.getSubject(), (PrivilegedExceptionAction)ofp)) == null ? 0 : myResults.length;
                if (nNewItems != realList.length) {
                    logger.severe(this.m_className, "fetchParticipants", "Mistmatched participant List");
                } else {
                    int j = 0;
                    for (int i = 0; i < nItems; ++i) {
                        VWParticipant newParticipant;
                        if (results[i] != null) continue;
                        results[i] = newParticipant = myResults[j];
                        this.TheParticipantCache.put(domainName, realList[j], newParticipant);
                        ++j;
                    }
                }
            }
            VWParticipant[] vWParticipantArray = results;
            Object var17_10 = null;
            this.stopTiming();
            return vWParticipantArray;
        }
        catch (Throwable e) {
            try {
                logger.throwing(this.m_className, "fetchParticipants", e);
                throw new VWException(e);
            }
            catch (Throwable throwable) {
                Object var17_11 = null;
                this.stopTiming();
                throw throwable;
            }
        }
    }

    public String getConnectionPointName() throws VWException {
        this.checkTransientObjects("getConnectionPointName");
        return this.m_connectionPoint.Name;
    }

    public String translate(String inStr) throws VWException {
        if (this.clientLocale != null) {
            String outStr;
            if (this.myXliff == null) {
                int myReg = this.getIsolatedRegion();
                this.myXliff = new VWXLIFFHandler(myReg);
            }
            if ((outStr = this.myXliff.getLocalizedString(this.clientLocale, inStr)) != null) {
                return outStr;
            }
        }
        return inStr;
    }

    public String translateToAuthored(String inStr) throws VWException {
        if (this.clientLocale != null) {
            String outStr;
            if (this.myXliff == null) {
                int myReg = this.getIsolatedRegion();
                this.myXliff = new VWXLIFFHandler(myReg);
            }
            if ((outStr = this.myXliff.getAuthoredString(this.clientLocale, inStr)) != null) {
                return outStr;
            }
        }
        return inStr;
    }

    public void setClientLocale(Locale myLocale) throws VWException {
        this.clientLocale = myLocale;
        if (this.clientLocale == null) {
            this.myXliff = null;
        } else if (this.myXliff == null) {
            int myReg = this.getIsolatedRegion();
            this.myXliff = new VWXLIFFHandler(myReg);
        }
    }

    public Locale getClientLocale() throws VWException {
        return this.clientLocale;
    }

    public String[] getAvailableLocales() throws VWException {
        String[] locStrs = (String[])this.executeRPC("orb_rpc_getAvailableLocales", new Object[0]);
        return locStrs;
    }

    public String getServerLocale() throws VWException {
        if (this.m_rpcConfigHdrResult == null) {
            this.executeRPC("orb_rpc_getCurrentVersion", null);
        }
        if (this.m_rpcConfigHdrResult == null) {
            throw new VWNoOnlineClassesException();
        }
        return this.m_rpcConfigHdrResult.serverLanguage;
    }

    public Boolean verifyDBConnection(VWDBExecuteConnection VWDbEx) throws VWException {
        return (Boolean)this.executeRPC("orb_rpc_verifyDBConnection", new Object[]{ORBUtility.VWDBExecuteConnectionToDBConnection(VWDbEx)});
    }

    public String[] fetchRoleNames(int accessFlag, String orbInAppSpaceName) throws VWException {
        AppSpaceAccessLevel bAccessLevel = AppSpaceAccessLevel.IGNORESECURITY;
        if (accessFlag == 0) {
            bAccessLevel = AppSpaceAccessLevel.READ;
        } else if (accessFlag == 1) {
            bAccessLevel = AppSpaceAccessLevel.WRITE;
        } else if (accessFlag == 2) {
            bAccessLevel = AppSpaceAccessLevel.IGNORESECURITY;
        } else {
            throw new VWException("orb.session.wrongApplicationSpaceAccessFlag", "Access level is not one of the supported levels.");
        }
        String[] memberShip = this.fetchMemberOf(this.m_username);
        return (String[])this.executeRPC("orb_rpc_fetchRoleNames", new Object[]{bAccessLevel, orbInAppSpaceName == null ? "" : orbInAppSpaceName, memberShip});
    }

    public VWRole[] fetchRoles(String orbInAppSpaceName, String[] orbInRoleNames) throws VWException {
        int nItems;
        String m_method = "fetchRoles";
        VWRole[] results = null;
        String[] memberShip = this.fetchMemberOf(this.m_username);
        RoleDefinitionInfo[] rArr = (RoleDefinitionInfo[])this.executeRPC("orb_rpc_fetchRoles", new Object[]{orbInAppSpaceName == null ? "" : orbInAppSpaceName, orbInRoleNames == null ? new String[]{} : orbInRoleNames, memberShip});
        int n = nItems = rArr == null ? 0 : rArr.length;
        if (nItems == 0) {
            return null;
        }
        results = new VWRole[nItems];
        for (int i = 0; i < nItems; ++i) {
            results[i] = ORBUtility.RoleDefinitionToVWRole(rArr[i], orbInAppSpaceName);
            if (!logger.isFinest()) continue;
            logger.finest(this.m_className, "fetchRoles", "fetched role " + rArr[i].name);
        }
        return results;
    }

    public String[] fetchAppSpaceNames(boolean ignoreSecurity) throws VWException {
        AppSpaceAccessLevel level = AppSpaceAccessLevel.IGNORESECURITY;
        if (!ignoreSecurity) {
            level = AppSpaceAccessLevel.WRITE;
        }
        String[] memberShip = this.fetchMemberOf(this.m_username);
        return (String[])this.executeRPC("orb_rpc_fetchAppSpaceNames", new Object[]{level, memberShip});
    }

    public VWParticipantList setRolePartipants(String orbInAppSpaceName, String orbInRoleName, String[] addParticipantNames, String[] removeParticipantNames) throws VWException {
        String[] memberShip = this.fetchMemberOf(this.m_username);
        ParticipantStruct[] rArr = (ParticipantStruct[])this.executeRPC("orb_rpc_setRolePartipants", new Object[]{orbInAppSpaceName, orbInRoleName, memberShip, addParticipantNames == null ? new String[]{} : addParticipantNames, removeParticipantNames == null ? new String[]{} : removeParticipantNames});
        VWParticipant[] res = ORBUtility.ParticipantArrayToVWParticipantArray(rArr);
        return VWClassFactory.createVWParticipantList(res);
    }

    public VWField[] createLaunchStepElement(String[] fieldNames, Object[] fieldValues, String workflowIdentifier, int numberToCreate, boolean returnWobNum) throws VWException {
        int fieldType;
        String m_method = "createLaunchStepElement:" + workflowIdentifier;
        inParamLogger.logObject(this.m_className, m_method, "FIELD NAMES", fieldNames);
        inParamLogger.logObject(this.m_className, m_method, "FIELD VALUES", fieldValues);
        Field[] fields = null;
        int i = 0;
        if (92626 == numberToCreate && workflowIdentifier.startsWith("~") && workflowIdentifier.substring(2, 4).equals("~~")) {
            numberToCreate = 1;
            int nFields = fieldNames.length + fieldValues.length;
            fields = new Field[nFields];
            for (i = 0; i < fieldNames.length; ++i) {
                fieldType = VWFieldType.getVWFieldType(fieldNames[i]);
                FValue val = ORBUtility.ObjectToFValue(fieldType, fieldNames[i]);
                fields[i] = new Field("Fa" + String.valueOf(i), val, fieldType, false, false, 3, true, new boolean[0], "", "");
            }
            for (int j = 0; j < fieldValues.length; ++j) {
                int fieldType2 = VWFieldType.getVWFieldType(fieldValues[j]);
                FValue val = ORBUtility.ObjectToFValue(fieldType2, fieldValues[j]);
                fields[i] = new Field("Fb" + String.valueOf(i), val, fieldType2, false, false, 3, true, new boolean[0], "", "");
                ++i;
            }
        } else if (fieldNames != null && fieldValues != null) {
            if (fieldNames.length != fieldValues.length) {
                throw new VWException("vw.api.SNumberofFieldNamesNotEqualNumberofFieldValues", "Number of field name must equal the number of field values.");
            }
            fields = new Field[fieldNames.length];
            for (i = 0; i < fieldNames.length; ++i) {
                if (fieldNames[i] == null) {
                    throw new VWException("vw.api.SFieldNameIsNull", "Field name is null: element={0}", i);
                }
                boolean isArray = false;
                if (fieldValues[i] != null) {
                    isArray = fieldValues[i].getClass().isArray();
                }
                fieldType = VWFieldType.getVWFieldType(fieldValues[i]);
                Object fieldValue = VWFieldUtility.convertFieldValue(fieldValues[i], fieldType, fieldNames[i], isArray);
                FValue val = ORBUtility.ObjectToFValue(fieldType, fieldValue);
                fields[i] = new Field(fieldNames[i], val, fieldType, false, isArray, 3, true, new boolean[0], "", "");
            }
        }
        VWField[] results = null;
        if (fields == null) {
            fields = new Field[]{};
        }
        try {
            Field[] res = (Field[])this.executeRPC("orb_rpc_createLaunchStepElement", new Object[]{workflowIdentifier, fields, returnWobNum});
            results = ORBUtility.FieldArraytoVWFieldArray(res);
        }
        catch (Exception e) {
            if (logger.isFinest()) {
                logger.throwing(this.m_className, m_method, e);
            }
            throw new VWException(e);
        }
        return results;
    }

    public VWApplicationSpace[] fetchApplicationSpaces(String[] inAppSpaceNames, int inFilterFlag) throws VWException {
        String m_method = "fetchApplicationSpaces:";
        inParamLogger.logObject(this.m_className, "fetchApplicationSpaces:", "APPLICATION SPACE NAMES", inAppSpaceNames);
        inParamLogger.logObject(this.m_className, "fetchApplicationSpaces:", "FILTER FLAG", inFilterFlag);
        VWApplicationSpace[] results = null;
        String[] groupMemberShip = this.fetchMemberOf(this.m_username);
        try {
            ApplicationSpaceInfo[] res = (ApplicationSpaceInfo[])this.executeRPC("orb_rpc_fetchApplicationSpaces", new Object[]{groupMemberShip, inAppSpaceNames == null ? new String[]{} : inAppSpaceNames, inFilterFlag});
            results = ORBUtility.appSpaceInfoArrayToVWAppSpaceArray(res);
        }
        catch (Exception ex) {
            if (logger.isFinest()) {
                logger.throwing(this.m_className, "fetchApplicationSpaces:", ex);
            }
            throw new VWException(ex);
        }
        return results;
    }

    public CEObjectInfo fetchCEObjectInfo(VWGuid objectStoreId, VWGuid classId, VWGuid objectId) throws VWException {
        String m_method = "fetchCEObject:";
        inParamLogger.logObject(this.m_className, "fetchCEObject:", "OBJECT STORE ID", objectStoreId);
        inParamLogger.logObject(this.m_className, "fetchCEObject:", "CLASS ID", classId);
        inParamLogger.logObject(this.m_className, "fetchCEObject:", "OBJECT ID", objectId);
        try {
            ORBFetchCEObject ofceo = new ORBFetchCEObject(this.m_cempUri, this.m_myJAASContext.getSubject());
            if (logger.isFinest()) {
                logger.finest(this.m_className, "fetchCEObject:", "doing as " + this.m_myJAASContext.getUserName());
            }
            CEObjectInfo result = ofceo.fetchCEObjectInfo(objectStoreId, classId, objectId);
            logger.exiting(this.m_className, "fetchCEObject:");
            return result;
        }
        catch (Exception ex) {
            throw new VWException(ex);
        }
    }

    public String fetchObjectStoreSymbolicName(VWGuid objectStoreId) throws VWException {
        String m_method = "fetchObjectStoreSymbolicName:";
        inParamLogger.logObject(this.m_className, "fetchObjectStoreSymbolicName:", "OBJECT STORE ID", objectStoreId);
        try {
            ORBFetchCEObject ofceo = new ORBFetchCEObject(this.m_cempUri, this.m_myJAASContext.getSubject());
            if (logger.isFinest()) {
                logger.finest(this.m_className, "fetchObjectStoreSymbolicName:", "doing as " + this.m_myJAASContext.getUserName());
            }
            String result = ofceo.fetchObjectStoreSymbolicName(objectStoreId);
            logger.exiting(this.m_className, "fetchObjectStoreSymbolicName:");
            return result;
        }
        catch (Exception ex) {
            throw new VWException(ex);
        }
    }

    public VWGuid fetchObjectStoreId(String objectStoreSymbolicName) throws VWException {
        String m_method = "fetchObjectStoreId:";
        inParamLogger.logObject(this.m_className, "fetchObjectStoreId:", "OBJECT STORE SYMBOLIC NAME", objectStoreSymbolicName);
        try {
            ORBFetchCEObject ofceo = new ORBFetchCEObject(this.m_cempUri, this.m_myJAASContext.getSubject());
            if (logger.isFinest()) {
                logger.finest(this.m_className, "fetchObjectStoreId:", "doing as " + this.m_myJAASContext.getUserName());
            }
            VWGuid result = ofceo.fetchObjectStoreId(objectStoreSymbolicName);
            logger.exiting(this.m_className, "fetchObjectStoreId:");
            return result;
        }
        catch (Exception ex) {
            throw new VWException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifyCreds() throws VWException {
        boolean bl;
        String m_method = "verifyCreds";
        UserContext old = UserContext.get();
        try {
            UserContext uc = new UserContext();
            UserContext.set((UserContext)uc);
            uc.pushSubject(this.m_myJAASContext.getSubject());
            User user = Factory.User.fetchCurrent((Connection)Factory.Connection.getConnection((String)this.m_cempUri), (PropertyFilter)USER_PF);
            String userName = user.get_ShortName();
            if (logger.isFinest()) {
                logger.finest(this.m_className, "verifyCreds", "Got username=" + userName);
            }
            bl = true;
            Object var8_9 = null;
        }
        catch (Throwable t) {
            boolean bl2;
            try {
                bl2 = false;
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                UserContext.set((UserContext)old);
                throw throwable;
            }
            UserContext.set((UserContext)old);
            return bl2;
        }
        UserContext.set((UserContext)old);
        return bl;
    }

    public CEObjectInfo fetchCEObjectInfoByName(VWGuid objectStoreId, String symbolicName) throws VWException {
        String m_method = "fetchCEObject:";
        inParamLogger.logObject(this.m_className, "fetchCEObject:", "OBJECT STORE ID", objectStoreId);
        inParamLogger.logObject(this.m_className, "fetchCEObject:", "SYMBOLIC NAME", symbolicName);
        try {
            ORBFetchCEObject ofceo = new ORBFetchCEObject(this.m_cempUri, this.m_myJAASContext.getSubject());
            if (logger.isFinest()) {
                logger.finest(this.m_className, "fetchCEObject:", "doing as " + this.m_myJAASContext.getUserName());
            }
            CEObjectInfo result = ofceo.fetchCEObjectInfoByName(objectStoreId, symbolicName);
            logger.exiting(this.m_className, "fetchCEObject:");
            return result;
        }
        catch (Exception ex) {
            throw new VWException(ex);
        }
    }

    static {
        shortCircuit = "Short Circuit PE API going directly to CEMP API";
        noShortCircuit = "No Short Circuit... trying old way...";
        G_ORB_RETRY_COUNT_SYNC = new Object();
        G_ORB_RETRY_COUNT = 0L;
        G_CONNECT_RETRY_COUNT_SYNC = new Object();
        G_CONNECT_RETRY_COUNT = 0L;
        USER_PF = null;
        USER_PF = new PropertyFilter();
        USER_PF.addIncludeProperty(2, null, null, "ShortName", null);
        G_USE_NAMESEVICE = ORBSession.GetPrivilegedSystemProperty("filenet.vw.api.usens") != null;
        ORBSession.GetPERPCMethods();
        try {
            RPC_CORBA_SLEEP = Integer.parseInt(ORBSession.GetPrivilegedSystemProperty("filenet.pe.corba.retry.sleep"));
        }
        catch (Throwable e) {
            RPC_CORBA_SLEEP = 5000;
        }
        String s = ClientInfoUtilities.GetClientInfo();
        logger.finer("PEAPI", "", ClientInfoUtilities.GetClientInfo());
        m_timer = new VWTimerLog();
        gNamesToIds = new WeakHashMap(10);
        nLogger = Logger.getLogger("filenet.pe.peorb.client.ORBSession.convertSecurityNamesToIds");
        USER_NONE = new Long(0L);
        USER_ANYONE = new Long(1L);
        USER_UNDEFINED = new Long(6L);
        USER_SERVICE_PROCESS = new Long(5L);
        USER_USER_DEFAULTS = new Long(7L);
        USER_GROUP_DEFAULTS = new Long(8L);
        USER_DEVICE_DEFAULTS = new Long(9L);
        USER_SYSTEM_DEFAULTS = new Long(10L);
        USER_SERVPROCTERM = new Long(14L);
    }
}

